/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever media content matches the overall syntax
 * defined for a media format, but uses a feature that is not supported by the
 * media format implementation, for example a specific sub-format. For example,
 * a format bean for the BMP format that supports Windows BMP format only will
 * throw such an exception when analyzing a BMP object featuring OS/2 BMP
 * definitions.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class FormatFeatureException extends MediaFormatException
{
   /**
    * @see javax.emb.MediaFormatException()
    */
   public FormatFeatureException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaFormatException(String)
    */
   public FormatFeatureException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaFormatException(String, Throwable)
    */
   public FormatFeatureException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaFormatException(Throwable)
    */
   public FormatFeatureException(Throwable cause)
   {
      super(cause);
   }
}