/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever a media format cannot be bound to the
 * media format registry because another media format instance is already bound
 * for the file extension specified.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class FormatAlreadyBoundException extends MediaFormatException
{
   /**
    * @see javax.emb.MediaFormatException()
    */
   public FormatAlreadyBoundException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaFormatException(String)
    */
   public FormatAlreadyBoundException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaFormatException(String, Throwable)
    */
   public FormatAlreadyBoundException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaFormatException(Throwable)
    */
   public FormatAlreadyBoundException(Throwable cause)
   {
      super(cause);
   }
}