/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This is thrown if the actual conversion of media content from one format to
 * another fails and the reason for this is not related to the media formats
 * involved, but rather because of a limitation of the converter. For example,
 * a BMP to JPEG converter can fail because it does not support a specific
 * format feature in the source, while the format bean handling the input
 * format itself may well support this feature.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class ConversionException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public ConversionException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public ConversionException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public ConversionException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public ConversionException(Throwable cause)
   {
      super(cause);
   }
}