/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown during <code>MediaEntityLocal.setContent()</code>
 * whenever the content cannot be manually changed on the entity.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class ContentUnmutableException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public ContentUnmutableException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public ContentUnmutableException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public ContentUnmutableException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public ContentUnmutableException(Throwable cause)
   {
      super(cause);
   }
}