/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever the creation of a byte array is attempted
 * that exceeds 2GB in size (the current hard limit of byte array size in
 * Java).
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class ContentTooLargeException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public ContentTooLargeException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public ContentTooLargeException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public ContentTooLargeException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public ContentTooLargeException(Throwable cause)
   {
      super(cause);
   }
}