/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.emb;

/**
 * This exception is thrown whenever access to media content fails, be it
 * because a file is not found, there's missing access rights to a file or
 * subsystem, a subsystem or file is temporarily blocked for access, or content
 * transmission fails.
 * 
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:ricardoarguello@users.sourceforge.net">Ricardo
 *         Argello</a>
 */
public class ContentAccessException extends MediaException
{
   /**
    * @see javax.emb.MediaException()
    */
   public ContentAccessException()
   {
      super();
   }

   /**
    * @see javax.emb.MediaException(String)
    */
   public ContentAccessException(String message)
   {
      super(message);
   }

   /**
    * @see javax.emb.MediaException(String, Throwable)
    */
   public ContentAccessException(String message, Throwable cause)
   {
      super(message, cause);
   }

   /**
    * @see javax.emb.MediaException(Throwable)
    */
   public ContentAccessException(Throwable cause)
   {
      super(cause);
   }
}