/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.StatelessSessionBeanStats;

/**
 * The JSR77.6.14 StatlessBeanStats implementation
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class StatelessSessionBeanStatsImpl extends EJBStatsImpl
        implements StatelessSessionBeanStats
{
   // Constants -----------------------------------------------------
   
   /** @since 4.0.2 */
   private static final long serialVersionUID = -5805813168279134341L;
   
   // Private Data --------------------------------------------------
   
   private RangeStatisticImpl methodReadyCount;

   // Constructors --------------------------------------------------
      
   public StatelessSessionBeanStatsImpl()
   {
      methodReadyCount = new RangeStatisticImpl("MethodReadyCount", "1",
              "The count of beans in the method-ready state");
      addStatistic("MethodReadyCount", methodReadyCount);
   }

// Begin javax.management.j2ee.statistics.StatelessSessionBeanStats interface methods

   public RangeStatistic getMethodReadyCount()
   {
      return methodReadyCount;
   }

// End javax.management.j2ee.statistics.StatelessSessionBeanStats interface methods
}
