/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.MessageDrivenBeanStats;

/**
 * The JSR77.6.13 MessageDrivenBeanStats implementation
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class MessageDrivenBeanStatsImpl extends EJBStatsImpl
        implements MessageDrivenBeanStats
{
   // Constants -----------------------------------------------------
   
   /** @since 4.0.2 */
   private static final long serialVersionUID = 3835482991422653299L;
   
   // Private Data --------------------------------------------------
   
   private CountStatisticImpl messageCount;

   // Constructors --------------------------------------------------
      
   public MessageDrivenBeanStatsImpl()
   {
      messageCount = new CountStatisticImpl("MessageCount", "1",
              "The count of messages received");
      addStatistic("MessageCount", messageCount);
   }

// Begin javax.management.j2ee.statistics.MessageDrivenBeanStats interface methods

   public CountStatistic getMessageCount()
   {
      return messageCount;
   }

// End javax.management.j2ee.statistics.MessageDrivenBeanStats interface methods
}
