/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:TimeStatistic.java,v 1.0, 2005-06-24 19:17:59Z, Robert Worsnop$


/**
 * Specifies standard timing measurements.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface TimeStatistic extends Statistic
{
   /**
    * Number of times the operation was invoked since the beginning of this measurement.
    */
   public long getCount();

   /**
    * The maximum amount of time taken to complete one invocation of this operation since the beginning of this measurement.
    */
   public long getMaxTime();

   /**
    * The minimum amount of time taken to complete one invocation of this operation since the beginning of this measurement.
    */
   public long getMinTime();

   /**
    * This is the sum total of time taken to complete every invocation of this operation since the beginning of this measurement.
    * Dividing totalTime by count will give you the average execution time for this operation.
    */
   public long getTotalTime();
}

