/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JMSConnectionStats.java,v 1.0, 2005-06-24 19:09:58Z, Robert Worsnop$

import javax.management.*;
import javax.management.j2ee.Management;
import javax.ejb.EJBObject;
import javax.ejb.EJBHome;
import javax.ejb.CreateException;
import java.rmi.RemoteException;
import java.util.Set;

/**
 * Specifies the statistics provided by a JMS connection
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JMSConnectionStats  extends Stats
{
   /**
    * Returns an array of JMSSessionStats that provide statistics about the sessions associated with the referencing JMSConnectionStats.
    */
   public JMSSessionStats[] getSessions();

   /**
    * Returns the transactional state of this JMS connection. If true, indicates that this JMS connection is transactional.
    */
   public boolean isTransactional();
}

