/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JDBCConnectionPoolStats.java,v 1.0, 2005-06-24 19:09:23Z, Robert Worsnop$



/**
 * Specifies the statistics provided by a JDBC connection pool.
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JDBCConnectionPoolStats extends JDBCConnectionStats
{
   /**
    * Number of connections created.
    */
   public CountStatistic getCreateCount();

   /**
    * Number of connections closed.
    */
   public CountStatistic getCloseCount();

   /**
    * Size of the connection pool.
    */
   public BoundedRangeStatistic getPoolSize();

   /**
    * Number of free connections in the pool.
    */
   public BoundedRangeStatistic getFreePoolSize();

   /**
    * Number of threads waiting for a connection.
    */
   public RangeStatistic getWaitingThreadCount();
}

