/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.j2ee.statistics;

// $Id:JCAConnectionPoolStats.java,v 1.0, 2005-06-24 19:09:17Z, Robert Worsnop$


/**
 * Specifies the statistics provided by a JCA Connection Pool
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JCAConnectionPoolStats extends JCAConnectionStats
{
   /**
    * The number of connections closed
    */
   public CountStatistic getCloseCount();

   /**
    * The number of connections created
    */
   public CountStatistic getCreateCount();

   /**
    * The number of free connections in the pool
    */
   public BoundedRangeStatistic getFreePoolSize();

   /**
    * The size of the connection pool
    */
   public BoundedRangeStatistic getPoolSize();

   /**
    * The number of threads waiting for a connection
    *
    * @return BoundedRangeStatistic
    */
   public RangeStatistic getWaitingThreadCount();

}

