/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.compliance.server.support;

import javax.management.MBeanServerDelegate;
import javax.management.Notification;

/**
 * An alternate MBeanServerDelegate
 *
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
public class TestMBeanServerDelegate
   extends MBeanServerDelegate
{
   public boolean invoked = false;

   public String getMBeanServerId()
   {
      invoked = true;
      return super.getMBeanServerId();
   }

   public void sendNotification(Notification notification)
   {
      notification.setUserData("replaced");
      super.sendNotification(notification);
   }
}
