/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.mx.service;


/**
 * Defines constants for JBossMX services.
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>. 
 * @version $Revision:1$
 */
public interface ServiceConstants
{
   /** 
    * The object name domain <tt>'JBossMX'<tt> can be used by
    * JBossMX service implementations.
    */
   final static String JBOSSMX_DOMAIN           = "JBossMX";
   
   /** 
    * Default object name for persistence interceptor with <tt>ON_TIMER</tt>
    * policy.
    */
   final static String PERSISTENCE_TIMER        = new String(JBOSSMX_DOMAIN + ":name=PersistenceTimer");
   
   /**
    * DTD file name for XMLMBeanLoader, version 1.0 
    */
   final static String MBEAN_LOADER_DTD_1_0     = "JBossMX_MBeanLoader_1_0.dtd";

   /** DTD file name for JBossMX XMBean, version 1.0 */
   final static String JBOSSMX_XMBEAN_DTD_1_0   = "jboss_xmbean_1_0.dtd";
   final static String PUBLIC_JBOSSMX_XMBEAN_DTD_1_0   = "-//JBoss//DTD JBOSS XMBEAN 1.0//EN";

   /** DTD file name for JBossMX XMBean, version 1.1 */
   final static String JBOSSMX_XMBEAN_DTD_1_1   = "jboss_xmbean_1_1.dtd";
   final static String PUBLIC_JBOSSMX_XMBEAN_DTD_1_1   = "-//JBoss//DTD JBOSS XMBEAN 1.1//EN";
  
   /** DTD file name for JBossMX XMBean, version 1.2 */
   final static String JBOSSMX_XMBEAN_DTD_1_2   = "jboss_xmbean_1_2.dtd";
   final static String PUBLIC_JBOSSMX_XMBEAN_DTD_1_2   = "-//JBoss//DTD JBOSS XMBEAN 1.2//EN";
   
}
      



