/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.notification;

import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.Notification;

/**
 * NotificationFilterProxy wraps a real filter by the users to pass down
 * to the mbean server so that as notification emitters apply the filter, the
 * appropriate source can be set in the notification object before passing to the
 * real filter.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class NotificationFilterProxy implements NotificationFilter
{
    private static final long serialVersionUID = 1L;
    private ObjectName source;
    private NotificationFilter delegate;

    public NotificationFilterProxy(ObjectName source, NotificationFilter delegate)
    {
        this.source = source;
        this.delegate = delegate;
    }

    /**
     * This method is called before a notification is sent to see whether
     * the listener wants the notification.
     *
     * @param notification the notification to be sent.
     * @return true if the listener wants the notification, false otherwise
     */
    public boolean isNotificationEnabled(Notification notification)
    {
        // replace with the real source of the event
        notification.setSource(source);
        return this.delegate.isNotificationEnabled(notification);
    }

    /**
     * return the real ObjectName source
     *
     * @return
     */
    public ObjectName getSource ()
    {
        return source;
    }
    /**
     * return the real NotificationFilter
     *
     * @return
     */
    public NotificationFilter getFilter ()
    {
        return delegate;
    }
}
