/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mx.notification;

import javax.management.NotificationFilter;
import javax.management.NotificationListener;

/**
 * A notification listener registration.<p>
 * 
 * @see org.jboss.mx.notification.ListenerRegistry
 * @see org.jboss.mx.notification.ListenerRegistrationFactory
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
public interface ListenerRegistration
{
   /**
    * Retrieve the listener for this registration.
    *
    * @return the listener
    */
   NotificationListener getListener();

   /**
    * Retrieve the filter for this registration.
    *
    * @return the listener
    */
   NotificationFilter getFilter();

   /**
    * Retrieve the handback object for this registration.
    *
    * @return the handback object
    */
   Object getHandback();

   /**
    * Retrieve the listener that was registered.
    *
    * This might be different from listener to use,
    * e.g. the registration factory may generate a proxy.
    *
    * @return the listener
    */
   NotificationListener getRegisteredListener();

   /**
    * Retrieve the filter that was registered.
    *
    * This might be different from filter to use,
    * e.g. the registration factory may generate a proxy.
    *
    * @return the filter
    */
   NotificationFilter getRegisteredFilter();

   /**
    * Used to tell the registration it is no longer required.
    */
   void removed();
}
