/***************************************
*                                     *
*  JBoss: The OpenSource J2EE WebOS   *
*                                     *
*  Distributable under LGPL license.  *
*  See terms of license at gnu.org.   *
*                                     *
***************************************/

package org.jboss.mx.loading;

import java.net.URL;

/** An extension of UnifiedClassLoader that manages a thread based loading
 * strategy to work around the locking problems associated with the VM
 * initiated locking due to the synchronized loadClassInternal method of
 * ClassLoader which cannot be overriden.

 * @author <a href="scott.stark@jboss.org">Scott Stark</a>
 * @version $Revision:1$
*/
public class UnifiedClassLoader3 extends UnifiedClassLoader
   implements UnifiedClassLoader3MBean
{
   // Static --------------------------------------------------------

   // Attributes ----------------------------------------------------

   // Constructors --------------------------------------------------
   /**
    * Construct a <tt>UnifiedClassLoader</tt> without registering it to the
    * classloader repository.
    *
    * @param url   the single URL to load classes from.
    */
   public UnifiedClassLoader3(URL url)
   {
      this(url, null);
   }
   /**
    * Construct a <tt>UnifiedClassLoader</tt> without registering it to the
    * classloader repository.
    *
    * @param url   the single URL to load classes from.
    * @param origURL the possibly null original URL from which url may
    * be a local copy or nested jar.
    */
   public UnifiedClassLoader3(URL url, URL origURL)
   {
      super(url, origURL);
   }

   /** Construct a UnifiedClassLoader and associate it with the given
    * repository.
    * @param url The single URL to load classes from.
    * @param origURL the possibly null original URL from which url may
    * be a local copy or nested jar.
    * @param repository the repository this classloader delegates to
    */
   public UnifiedClassLoader3(URL url, URL origURL, LoaderRepository repository)
   {
      this(url, origURL);

      // set the repository reference
      this.setRepository(repository);
   }
   /** Construct a UnifiedClassLoader and associate it with the given
    * repository.
    * @param url The single URL to load classes from.
    * @param origURL the possibly null original URL from which url may
    * be a local copy or nested jar.
    * @param parent the parent class loader to use
    * @param repository the repository this classloader delegates to
    */
   public UnifiedClassLoader3(URL url, URL origURL, ClassLoader parent,
         LoaderRepository repository)
   {
      super(url, origURL, parent);

      // set the repository reference
      this.setRepository(repository);
   }

   // Public --------------------------------------------------------

   /**
   * Retruns a string representaion of this UCL.
   */
   public String toString()
   {
      StringBuffer tmp = new StringBuffer(super.toString());
      tmp.setCharAt(tmp.length()-1, ',');
      tmp.append("addedOrder=");
      tmp.append(getAddedOrder());
      tmp.append('}');
      return tmp.toString();
   }
}
