/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

import java.io.Serializable;

import org.jboss.mx.util.QueryExpSupport;

/**
 * Support for evaluting a query in the context of an MBeanServer.
 *
 * <p><b>Revisions:</b>
 * <p><b>20020317 Adrian Brock:</b>
 * <ul>
 * <li>Make queries thread safe
 * </ul>
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
public abstract class QueryEval
   implements Serializable
{
   // Constants ---------------------------------------------------

   private static final long serialVersionUID = 2675899265640874796L;
   
   // Attributes --------------------------------------------------

   // Static ------------------------------------------------------

   // Public ------------------------------------------------------

   /** Return the MBean server that was most recently given to the
    * setMBeanServer method by this thread. If this thread never called that
    * method, the result is the value its parent thread would have obtained
    * from getMBeanServer at the moment of the creation of this thread, or
    * null if there is no parent thread.
    *
    * @return the current MBeanServer thread association.
    */
   public static MBeanServer getMBeanServer()
   {
      return (MBeanServer) QueryExpSupport.server.get();
   }

   /**
    * Set the MBeanServer for this query. Only MBeans registered in
    * this server can be used in queries.
    *
    * @param mbeanServer the MBeanServer
    */
   public void setMBeanServer(MBeanServer mbeanServer)
   {
      QueryExpSupport.server.set(mbeanServer);
   }
}
