/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * An OR Query Expression.<p>
 *
 * Returns true when either expression is true.
 *
 * <p><b>Revisions:</b>
 * <p><b>20020314 Adrian Brock:</b>
 * <ul>
 * <li>Fix the human readable expression
 * </ul>
 * <p><b>20020317 Adrian Brock:</b>
 * <ul>
 * <li>Make queries thread safe
 * </ul>
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
class OrQueryExp extends QueryEval implements QueryExp
{
   // Constants ---------------------------------------------------

   private static final long serialVersionUID = 2962973084421716523L;

   // Attributes --------------------------------------------------

   /**
    * The first query expression
    */
   private QueryExp exp1;

   /**
    * The second query expression
    */
   private QueryExp exp2;


   // Constructors ------------------------------------------------

   public OrQueryExp()
   {
   }
   
   /**
    * Create a new OR query Expression
    * 
    * @param first the first query expression
    * @param second the second query expression
    */
   public OrQueryExp(QueryExp first, QueryExp second)
   {
      this.exp1 = first;
      this.exp2 = second;
   }

   // Public ------------------------------------------------------

   // QueryExp implementation -------------------------------------

   public boolean apply(ObjectName name)
      throws BadStringOperationException,
      BadBinaryOpValueExpException,
      BadAttributeValueExpException,
      InvalidApplicationException
   {
      return exp1.apply(name) || exp2.apply(name); 
   }

   // Object overrides --------------------------------------------

   public String toString()
   {
      return new String("(" + exp1.toString() + ") || (" + exp2.toString()) + ")";
   }

}
