/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management;

/**
 * A NOT Query Expression.<p>
 *
 * Returns true when either expression is false.
 *
 * <p><b>Revisions:</b>
 * <p><b>20020314 Adrian Brock:</b>
 * <ul>
 * <li>Fix the human readable expression
 * </ul>
 * <p><b>20020317 Adrian Brock:</b>
 * <ul>
 * <li>Make queries thread safe
 * </ul>
 * 
 * @author  <a href="mailto:Adrian.Brock@HappeningTimes.com">Adrian Brock</a>.
 * @version $Revision:1$
 */
class NotQueryExp extends QueryEval implements QueryExp
{
   // Constants ---------------------------------------------------

   private static final long serialVersionUID = 5269643775896723397L;

   // Attributes --------------------------------------------------

   /**
    * The query expression to negate
    */
   private QueryExp exp;

   // Static ------------------------------------------------------

   // Constructors ------------------------------------------------

   public NotQueryExp()
   {
   }

   /**
    * Create a new NOT query Expression
    * 
    * @param expression the query expression to negate
    */
   public NotQueryExp(QueryExp expression)
   {
      this.exp = expression;
   }

   // Public ------------------------------------------------------

   // QueryExp implementation -------------------------------------

   public boolean apply(ObjectName name)
      throws BadStringOperationException,
      BadBinaryOpValueExpException,
      BadAttributeValueExpException,
      InvalidApplicationException
   {
      return !exp.apply(name); 
   }

   // Object overrides --------------------------------------------

   public String toString()
   {
      return new String("!(" + exp.toString() + ")" );
   }

   // Protected ---------------------------------------------------

   // Private -----------------------------------------------------

   // Inner classes -----------------------------------------------
}
