/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:ObjectNameSer.java,v 1.0, 2005-06-24 19:13:16Z, Robert Worsnop$

package org.jboss.net.jmx.adaptor;

import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.ser.SimpleSerializer;
import org.jboss.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;

import javax.management.ObjectName;
import javax.xml.namespace.QName;

/**
 * Serializer specialized to turn JMX-Objectnames into
 * corresponding XML-types.
 * @since 26.04.2002
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @version $Revision:1$
 */

public class ObjectNameSer extends SimpleSerializer
{

   public ObjectNameSer(Class javaType, QName xmlType)
   {
      super(javaType, xmlType);
   }

   public String getValueAsString(Object value, SerializationContext context)
   {
      return ((ObjectName)value).getCanonicalName();
   }

   /* (non-Javadoc)
    * @see org.jboss.axis.encoding.Serializer#writeSchema(java.lang.Class, org.jboss.axis.wsdl.fromJava.Types)
    */
   public Element writeSchema(Class clazz, Types types) throws Exception
   {
      // ComplexType representation of SimpleType bean class
      Element complexType = types.createElement("complexType");
      //types.writeSchemaElement(xmlType, complexType);
      types.writeSchemaElement(xmlType, complexType);
      complexType.setAttribute("name", xmlType.getLocalPart());

      // Produce simpleContent extending base type.
      Element simpleContent = types.createElement("simpleContent");
      complexType.appendChild(simpleContent);
      Element extension = types.createElement("extension");
      simpleContent.appendChild(extension);

      // Get the base type from the "value" element of the bean
      String base = "string";
      extension.setAttribute("base", base);
      // done
      return complexType;
   }

}