/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:AttributeDeser.java,v 1.0, 2005-06-24 18:46:15Z, Robert Worsnop$

package org.jboss.net.jmx.adaptor;

import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.encoding.Target;
import org.jboss.axis.encoding.TypeMapping;
import org.jboss.axis.message.SOAPHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import javax.management.Attribute;
import javax.xml.namespace.QName;

/**
 * An <code>AttributeDeser</code> is be used to deserialize
 * Attribute objects using the <code>SOAP-ENC</code>
 * encoding style.<p>
 * @since 26.04.03
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @author <a href="mailto:Christoph.Jung@infor.de">Christoph G. Jung</a>
 * @version $Revision:1$
 */
public class AttributeDeser extends DeserializerImpl
{

   //
   // Attributes
   //

   protected String attributeName;
   protected Object attributeValue;
   protected QName xmlType;

   //
   // Constructors
   //

   public AttributeDeser(Class javaClass, QName xmlType)
   {
      this.xmlType = xmlType;
   }

   /** we can already defer the attribute name */
   public void onStartElement(String namespace,
                              String localName,
                              String qName,
                              Attributes attributes,
                              DeserializationContext context)
           throws SAXException
   {
      attributeName = attributes.getValue("", "name");
   }

   /** dispatch to the deserializer for the value element */
   public SOAPHandler onStartChild(String namespace,
                                   String localName,
                                   String prefix,
                                   Attributes attributes,
                                   DeserializationContext context)
           throws SAXException
   {
      if (localName.equals("value") && namespace.equals(""))
      {
         QName qn =
                 context.getTypeFromAttributes(namespace, localName, attributes);
         // get the deserializer
         Deserializer dSer = context.getDeserializerForType(qn);
         // If no deserializer, use the base DeserializerImpl.
         // There may not be enough information yet to choose the
         // specific deserializer.
         if (dSer == null)
         {
            dSer = new DeserializerImpl();
            // determine a default type for this child element
            TypeMapping tm = context.getTypeMapping();
            dSer.setDefaultType(tm.getTypeQName(Object.class));
            dSer.registerValueTarget(new AttributeValueTarget());
         }
         return (SOAPHandler)dSer;
      }
      else
      {
         return null;
      }
   }

   /**
    * Append any characters to the value.  This method is defined by 
    * Deserializer.
    */
   public void onEndElement(String namespace,
                            String localName,
                            DeserializationContext context)
           throws SAXException
   {
      if (isNil)
      {
         value = null;
         return;
      }

      value = new Attribute(attributeName, attributeValue);
   }

   //
   // Inner classes
   //

   protected class AttributeValueTarget implements Target
   {
      public void set(Object value) throws SAXException
      {
         attributeValue = value;
      }
   }

}
