/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.w3c.dom;

// $Id:DOMConfiguration.java,v 1.0, 2005-06-24 19:01:49Z, Robert Worsnop$

/**
 * The <code>DOMConfiguration</code> interface represents the configuration
 * of a document and maintains a table of recognized parameters.
 *
 * @since DOM Level 3
 */
public interface DOMConfiguration
{
   /**
    * Set the value of a parameter.
    */
   public void setParameter(String name, Object value) throws DOMException;

   /**
    *  Return the value of a parameter if known.
    */
   public Object getParameter(String name) throws DOMException;

   /**
    * Check if setting a parameter to a specific value is supported.
    */
   public boolean canSetParameter(String name, Object value);

   /**
    *  The list of the parameters supported by this
    * <code>DOMConfiguration</code> object and for which at least one value
    * can be set by the application. Note that this list can also contain
    * parameter names defined outside this specification.
    */
   public DOMStringList getParameterNames();

}
