/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *    Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.jboss.axis.transport.http;

import org.jboss.axis.AxisEngine;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.client.Call;
import org.jboss.axis.client.Transport;

/**
 * Extends Transport by implementing the setupMessageContext function to
 * set HTTP-specific message context fields and transport chains.
 * May not even be necessary if we arrange things differently somehow.
 * Can hold state relating to URL properties.
 *
 * @author Rob Jellinghaus (robj@unrealities.com)
 * @author Doug Davis (dug@us.ibm.com)
 * @author Glen Daniels (gdaniels@allaire.com)
 */
public class HTTPTransport extends Transport
{
   public static final String DEFAULT_TRANSPORT_NAME = "http";

   /**
    * HTTP properties
    */
   public static final String URL = MessageContext.TRANS_URL;

   private String cookie;
   private String cookie2;
   private String action;

   public HTTPTransport()
   {
      transportName = DEFAULT_TRANSPORT_NAME;
   }

   /**
    * helper constructor
    */
   public HTTPTransport(String url, String action)
   {
      transportName = DEFAULT_TRANSPORT_NAME;
      this.url = url;
      this.action = action;
   }

   /**
    * Set up any transport-specific derived properties in the message context.
    *
    * @param context the context to set up
    * @param message the client service instance
    * @param engine  the engine containing the registries
    * @throws AxisFault if service cannot be found
    */
   public void setupMessageContextImpl(MessageContext mc,
                                       Call call,
                                       AxisEngine engine)
           throws AxisFault
   {
      if (action != null)
      {
         mc.setUseSOAPAction(true);
         mc.setSOAPActionURI(action);
      }

      // Set up any cookies we know about
      if (cookie != null)
         mc.setProperty(HTTPConstants.HEADER_COOKIE, cookie);
      if (cookie2 != null)
         mc.setProperty(HTTPConstants.HEADER_COOKIE2, cookie2);

      // Allow the SOAPAction to determine the service, if the service
      // (a) has not already been determined, and (b) if a service matching
      // the soap action has been deployed.
      if (mc.getService() == null)
      {
         mc.setTargetService((String)mc.getSOAPActionURI());
      }
   }

   public void processReturnedMessageContext(MessageContext context)
   {
      cookie = context.getStrProp(HTTPConstants.HEADER_COOKIE);
      cookie2 = context.getStrProp(HTTPConstants.HEADER_COOKIE2);
   }
}
