/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.axis.message;

// $Id:SOAPBodyImpl.java,v 1.0, 2005-06-24 19:16:30Z, Robert Worsnop$

import org.jboss.axis.AxisFault;
import org.jboss.axis.NotImplementedException;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import java.util.Locale;

/**
 * An implemenation of the abstract SOAPBody.
 * <p/>
 * This class should not expose functionality that is not part of
 * {@link SOAPBody}. Client code should use <code>SOAPBody</code> whenever possible.
 *
 * @author Thomas Diesler (thomas.diesler@jboss.org)
 */
public class SOAPBodyImpl extends SOAPElementAxisImpl implements SOAPBody
{

   private static Logger log = Logger.getLogger(SOAPBodyImpl.class.getName());

   public SOAPBodyImpl(String namespace, String localPart)
   {
      super(namespace, localPart);
   }

   public SOAPBodyImpl(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault
   {
      super(namespace, localPart, prefix, attributes, context);
   }

   public SOAPBodyElement addBodyElement(Name name) throws SOAPException
   {
      throw new NotImplementedException();
   }

   public SOAPBodyElement addDocument(Document doc) throws SOAPException
   {
      throw new NotImplementedException();
   }

   public SOAPFault addFault() throws SOAPException
   {
      throw new NotImplementedException();
   }

   public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException
   {
      throw new NotImplementedException();
   }

   public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException
   {
      throw new NotImplementedException();
   }

   public SOAPFault getFault()
   {
      throw new NotImplementedException();
   }

   public boolean hasFault()
   {
      throw new NotImplementedException();
   }

}
