/*
 * JBoss, the OpenSource WebOS
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi.work;

import java.util.EventListener;

/**
 * Listens to events on work
 * @version $Revision:1$
 */
public interface WorkListener extends EventListener
{
   /**
    * Invoked when work is accepted
    *
    * @param e the event
    */
   void workAccepted(WorkEvent e);

   /**
    * Invoked when work is rejected
    *
    * @param e the event
    */
   void workRejected(WorkEvent e);

   /**
    * Invoked when work is started
    *
    * @param e the event
    */
   void workStarted(WorkEvent e);

   /**
    * Invoked when work is completed
    *
    * @param e the event
    */
   void workCompleted(WorkEvent e);
}