/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.proxy.ejb;

import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.rmi.PortableRemoteObject;

import org.jboss.iiop.CorbaORB;

/**
 * An <code>ObjectFactory</code> implementation that translates
 * <code>Reference</code>s to <code>EJBHome</code>s back into CORBA
 * object references. The IIOP proxy factory (IORFactory) binds these 
 * <code>Reference</code>s in the JRMP/JNDI namespace.
 *
 * @author  <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 * @version $Revision:1$
 */
public class IIOPHomeFactory implements ObjectFactory 
{

   public IIOPHomeFactory()
   {
   }
   
   // Implementation of the interface ObjectFactory ------------------------
   
   /** Lookup the IOR from the Reference and convert into the CORBA
    * object value using the ORB.string_to_object method.
    * 
    * @param obj a javax.naming.Reference with a string IOR under the
    *    address type IOR.
    * @param name not used
    * @param nameCtx not used
    * @param environment not used
    * @return The EJBHome proxy for the IOR
    * @throws Exception
    */ 
   public Object getObjectInstance(Object obj, Name name,
                                   Context nameCtx, Hashtable environment)
      throws Exception
   {
      Reference ref = (Reference) obj;
      String ior = (String) ref.get("IOR").getContent();
      org.omg.CORBA.Object corbaObj = CorbaORB.getInstance().string_to_object(ior);
      return (EJBHome) PortableRemoteObject.narrow(corbaObj, EJBHome.class);
   }
}

