/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.iiop.csiv2;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.PolicyFactory;

import org.jboss.metadata.IorSecurityConfigMetaData;

/**
 * Factory of <code>org.omg.CORBA.Policy</code> objects containing 
 * csiv2 ior security config info
 *
 * @author  Dimitris.Andreadis@jboss.org
 * @version $Revision:1$
 */
class CSIv2PolicyFactory
   extends LocalObject
   implements PolicyFactory 
{
   /** @since 4.0.1 */
   static final long serialVersionUID = -1954560842682170217L;

   private Codec codec;
   
   // Constructor -------------------------------------------------------------
   public CSIv2PolicyFactory(Codec codec)
   {
      // cache the codec
      this.codec = codec;
   }

   // org.omg.PortableInterceptor.PolicyFactory operations --------------------

   public Policy create_policy(int type, Any value)
      throws PolicyError
   {
      if (type != CSIv2Policy.TYPE) {
         throw new PolicyError();
      }
      
      // stored as java.io.Serializable - is this a hack?
      IorSecurityConfigMetaData metadata =
         (IorSecurityConfigMetaData)value.extract_Value();
         
      return new CSIv2Policy(metadata, codec);
   }
}
