/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.iiop;

import org.omg.CORBA.ORB;
import org.w3c.dom.Element;
import javax.ejb.spi.HandleDelegate;

/**
 *   Mbean interface for the JBoss CORBA ORB service.
 *      
 *   @author <a href="mailto:osh@sparre.dk">Ole Husgaard</a>
 *   @author <a href="mailto:reverbel@ime.usp.br">Francisco Reverbel</a>
 *   @version $Revision:1$
 */
public interface CorbaORBServiceMBean
   extends org.jboss.system.ServiceMBean
{
   public ORB getORB();

   public HandleDelegate getHandleDelegate();
   
   public String getORBClass();
   public void setORBClass(String orbClass);

   public String getORBSingletonClass();
   public void setORBSingletonClass(String orbSingletonClass);

   public String getORBSingletonDelegate();
   public void setORBSingletonDelegate(String orbSingletonDelegate);

   public void setORBPropertiesFileName(String orbPropertiesFileName);
   public String getORBPropertiesFileName();

   public Element getPortableInterceptorInitializers();
   public void setPortableInterceptorInitializers(
                                      Element portableInterceptorInitializers);

   public void setPort(int port);
   public int getPort();

   public void setSSLPort(int sslPort);
   public int getSSLPort();

   public void setSecurityDomain(String sslDomain);
   public String getSecurityDomain();

   boolean getSSLComponentsEnabled();
   void setSSLComponentsEnabled(boolean sslComponentsEnabled);

   boolean getSendSASAcceptWithExceptionEnabled();
   void setSendSASAcceptWithExceptionEnabled(boolean value);

   boolean getSunJDK14IsLocalBugFix();
   void setSunJDK14IsLocalBugFix(boolean sunJDK14IsLocalBugFix);
}

