/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.deployment.spi.status;

import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.DeploymentStatus;

// $Id:DeploymentStatusImpl.java,v 1.0, 2005-06-24 19:01:13Z, Robert Worsnop$

/**
 * The DeploymentStatus interface provides information about the progress status of a deployment action.
 * 
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 */
public class DeploymentStatusImpl implements DeploymentStatus
{

   private StateType stateType;
   private CommandType commandType;
   private ActionType actionType;
   private String message;

   public DeploymentStatusImpl(StateType stateType, CommandType commandType, ActionType actionType, String message)
   {
      this.stateType = stateType;
      this.commandType = commandType;
      this.actionType = actionType;
      this.message = message;
   }

   /**
    * Set the current deployment status
    */
   void setStateType(StateType stateType)
   {
      this.stateType = stateType;
   }

   /**
    * Set the current deployment message
    */
   void setMessage(String message)
   {
      this.message = message;
   }

   /**
    * Get the state of the deployment
    *
    * @return the state
    */
   public StateType getState()
   {
      return stateType;
   }

   /**
    * The deployment command
    * 
    * @return the command
    */
   public CommandType getCommand()
   {
      return commandType;
   }

   /**
    * The action of this deployment
    * 
    * @return the action
    */
   public ActionType getAction()
   {
      return actionType;
   }

   /**
    * Get the message
    * 
    * @return the message
    */
   public String getMessage()
   {
      return message;
   }

   /**
    * Is the deployment complete
    * 
    * @return true when complete, false otherwise
    */
   public boolean isCompleted()
   {
      return stateType == StateType.COMPLETED;
   }

   /**
    * Has the deployment failed
    * 
    * @return true when failed, false otherwise
    */
   public boolean isFailed()
   {
      return stateType == StateType.FAILED;
   }

   /**
    * Is the deployment in progress
    * 
    * @return true when in progress, false otherwise
    */
   public boolean isRunning()
   {
      return stateType == StateType.RUNNING;
   }
}
