/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.console.plugins;

import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.GraphMBeanAttributeAction;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.console.plugins.helpers.jmx.DomainData;
import org.jboss.console.plugins.helpers.jmx.MBeanData;
import org.jboss.console.plugins.helpers.jmx.Server;
import org.jboss.mx.util.InstanceOfQueryExp;

import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.MBeanServer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.HashSet;
import java.util.Set;
/**
 * As the number of MBeans is very big, we use a real Java class which is far
 * faster than beanshell
 *
 * @see <related>
 *
 * @author  <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @version $Revision:1$
 *
 * <p><b>Revisions:</b>
 *
 * <p><b>2 janv. 2003 Sacha Labourey:</b>
 * <ul>
 * <li> First implementation </li>
 * </ul>
 */
public class MonitorLister 
   extends AbstractPluginWrapper
{
   public MonitorLister () { super(); }

   TreeNode[] createMonitorSubNodes ()  throws Exception
   {
      MBeanServer mbeanServer = getMBeanServer();
      InstanceOfQueryExp queryExp = null;
      queryExp = new InstanceOfQueryExp("org.jboss.monitor.JBossMonitorMBean");
      Set monitors = mbeanServer.queryNames(null, queryExp);
      Iterator mbeans = monitors.iterator();;
      
      TreeNode[] result = null;
      
      ArrayList monitorNodes = new ArrayList ();

      String emptySig[] = {};
      Object emptyArgs[] = {};
      while( mbeans.hasNext() )
      {
         ObjectName mbean = (ObjectName)mbeans.next();
         String monitorName = (String)mbeanServer.getAttribute(mbean, "MonitorName");
         boolean alerted = ((Boolean)mbeanServer.invoke(mbean, "alerted", emptyArgs, emptySig)).booleanValue();
         //String image = alerted ? "images/red_bullet.gif" : "images/green_bullet.gif";
         String image = "images/service.gif";
         Object[] args = {"monitors", monitorName, "-service.xml"};
         String[] signature = {"java.lang.String", "java.lang.String", "java.lang.String"};
         Object rtn = mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "isStored", args, signature);
         boolean persisted = ((Boolean)rtn).booleanValue();
         String url = "";
         if (persisted)
         {
            url = "manageThresholdMonitor.jsp?monitorObjectName=" + encode(mbean.toString());
         }
         else
         {
            url = "/jmx-console/HtmlAdaptor?action=inspectMBean&name=" +encode(mbean.toString());
         }
         monitorNodes.add(createTreeNode (
               monitorName, // name
               "Alert Monitor " + monitorName, // description
               image, // Icon URL
               url, // Default URL
               null, // menu
               null, // sub nodes
               null   // Sub-Resources                  
            )
         );       
         
      }
      
      if (monitorNodes.size() == 0)
      {
         result = null;
      }
      else
      {
         result = (TreeNode[]) monitorNodes.toArray(new TreeNode[monitorNodes.size()]);
      }
      
      return result;                                                  
   }
   
   TreeNode[] createSnapshotSubNodes()  throws Exception
   {
      MBeanServer mbeanServer = getMBeanServer();
      InstanceOfQueryExp queryExp = null;
      queryExp = new InstanceOfQueryExp("org.jboss.monitor.SnapshotRecordingMonitorMBean");
      Set monitors = mbeanServer.queryNames(null, queryExp);
      Iterator mbeans = monitors.iterator();;

      TreeNode[] result = null;

      ArrayList monitorNodes = new ArrayList ();

      while( mbeans.hasNext() )
      {
         ObjectName mbean = (ObjectName)mbeans.next();
         String monitorName = (String)mbeanServer.getAttribute(mbean, "MonitorName");
         String url = "manageSnapshot.jsp?monitorObjectName=" + encode(mbean.toString());
         String image = "images/service.gif";
         monitorNodes.add(createTreeNode (
               monitorName, // name
               "Snapshot " + monitorName, // description
               image, // Icon URL
               url, // Default URL
               null, // menu
               null, // sub nodes
               null   // Sub-Resources
            )
         );

      }

      if (monitorNodes.size() == 0)
      {
         result = null;
      }
      else
      {
         result = (TreeNode[]) monitorNodes.toArray(new TreeNode[monitorNodes.size()]);
      }

      return result;
   }

   protected TreeNode getTreeForResource(String profile, ManageableResource resource)
   {
      try
      {
         TreeNode[] subnodes = new TreeNode[3];
         subnodes[0] = createTreeNode (
               "Alerts", // name
               "Alert Monitors", // description
               "images/smallnet.gif", // Icon URL
               "listMonitors.jsp", // Default URL
               null,
               createMonitorSubNodes(), // sub nodes
               null   // Sub-Resources
            );
         subnodes[1] = createTreeNode (
               "Snapshots", // name
               "Snapshot Monitors", // description
               "images/smallnet.gif", // Icon URL
               null, // Default URL
               null,
               createSnapshotSubNodes(), // sub nodes
               null   // Sub-Resources
            );
         TreeNode[] webSubnodes = new TreeNode[2];
         webSubnodes[0] = createTreeNode (
               "Connector scoreboard", // name
               "JBossWeb Connectors status scoreboard", // description
               "images/smallnet.gif", // Icon URL
               "status", // Default URL
               null,
               null, // sub nodes
               null   // Sub-Resources
            );
         webSubnodes[1] = createTreeNode (
               "Full status", // name
               "JBossWeb complete status", // description
               "images/smallnet.gif", // Icon URL
               "status?full=true", // Default URL
               null,
               null, // sub nodes
               null   // Sub-Resources
            );
         subnodes[2] = createTreeNode (
               "Web Status", // name
               "JBossWeb Connectors status", // description
               "images/smallnet.gif", // Icon URL
               null, // Default URL
               null,
               webSubnodes, // sub nodes
               null   // Sub-Resources
            );
         return createTreeNode (
               "Monitors", // name
               "Monitors", // description
               "images/smallnet.gif", // Icon URL
               null, // Default URL
               null,
               subnodes, // sub nodes
               null   // Sub-Resources
            );
      }
      catch (Exception e)
      {
         e.printStackTrace ();
         return null;
      }
   }
}
