/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.console.plugins;

import java.util.Iterator;

import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;

import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.console.plugins.helpers.jmx.Server;
import org.jboss.management.j2ee.WebModuleMBean;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mx.util.MBeanProxy;

/**
 *
 * 
 */
public class JMSLister extends AbstractPluginWrapper
{

	protected final static String JMX_JSR77_DOMAIN = "jboss.management.local";
   
	public JMSLister () 
	{ 
		super(); 
	}    

	protected TreeNode getTreeForResource(String profile, ManageableResource resource)
	{
	   try
	   {		  		  
		  ObjectName objName = ((MBeanResource)resource).getObjectName();		  
		  SimpleTreeNode node = createTreeNode(
		  							objName.getKeyProperty("name"),  // name
		   							"", // description
									"images/spirale.gif", // Icon URL
									null, // Default URL									
									null,  
									createDestinations(), // sub nodes 
									null // Sub-Resources                 
									);
		  node.setMasterNode(true);
		  return node;                  
         
	   }
	   catch (Exception e)
	   {
		  e.printStackTrace ();
		  System.out.println (checker);
		  return null;
         
	   }
	}
	
	private TreeNode[] createDestinations() throws Exception
	{
		TreeNode[] destinations = new TreeNode[2];
		
		destinations[0] = createTreeNode("Queues", "", "images/spirale.gif", null, null, null, createDestinationItems("Queue"));
		destinations[1] = createTreeNode("Topics", "", "images/spirale.gif", null, null, null, createDestinationItems("Topic"));
		
		return destinations; 	
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	private ResourceTreeNode[] createDestinationItems(String type) throws Exception
	{
		ObjectInstance[] insts = getMBeansForQuery("jboss.mq.destination:service=" + type + ",*", null);
		ResourceTreeNode[] destinations = new ResourceTreeNode[insts.length];  
		//JMSDestinationManager jmsServer = (JMSDestinationManager)this.mbeanServer.getAttribute(new ObjectName("jboss.mq:service=DestinationManager"), "Interceptor");
		for (int i=0; i < insts.length; i++)
		{
			ObjectName objName = insts[i].getObjectName();
			destinations[i] = createDestinationItem(objName);					
		}
		return destinations;
	}

	/**
	 * @param objName
	 * @return
	 */
	private ResourceTreeNode createDestinationItem(ObjectName objName) throws Exception
	{
		String destinationName = objName.getKeyProperty("name");
		String type = objName.getKeyProperty("service");
		String className = 	this.mbeanServer.getMBeanInfo(objName).getClassName();
		String fileName = "";
		if (type.equalsIgnoreCase("Queue"))
		{
			fileName = "Queue.jsp";			
		}
		else if (type.equalsIgnoreCase("Topic"))
		{
			fileName = "Topic.jsp";
		}
		
		ResourceTreeNode item = this.createResourceNode
									(destinationName,  
									type, //Description Tooltip
									"images/serviceset.gif",
									fileName+"?ObjectName=" + encode(objName.toString()),
									null, //menus 
									null, //sub-nodes
									null, //sub-resources
									objName.toString(),
									className);			
		return item;																					
	}


}
