/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.console.manager;

import org.jboss.system.ServiceMBean;

import java.io.IOException;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 *
 **/
public interface DeploymentFileRepositoryMBean extends ServiceMBean
{
   void store(String folder, String name, String fileExtension, String data, boolean noHotDeploy) throws IOException;

   void remove(String folder, String name, String fileExtension);

   boolean isStored(String folder, String name, String fileExtension);

   String getBaseDir();

   void setBaseDir(String baseDir);
}
