/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.resource.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Principal;
import java.io.UnsupportedEncodingException;

import org.jboss.security.SecurityAssociation;

/** PrivilegedActions used by this package
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
class GetPrincipalInfoAction
{
   private static class GetPrincipalAction implements PrivilegedAction
   {
      static PrivilegedAction ACTION = new GetPrincipalAction();
      public Object run()
      {
         Principal principal = SecurityAssociation.getPrincipal();
         return principal;
      }
   }
   private static class GetCredentialAction implements PrivilegedAction
   {
      static PrivilegedAction ACTION = new GetCredentialAction();
      public Object run()
      {
         Object credential = SecurityAssociation.getCredential();
         char[] password = null;
         /* Obtain the password credential by trying char[], byte[],
          and toString()
          */
          if( credential instanceof char[] )
          {
             password = (char[]) credential;
          }
          else if( credential instanceof byte[] )
          {
             try
             {
                String tmp = new String((byte[]) credential, "UTF-8");
                password = tmp.toCharArray();
             }
             catch (UnsupportedEncodingException e)
             {
                throw new SecurityException(e.getMessage());
             }
          }
          else if( credential != null )
          {
             String tmp = credential.toString();
             password = tmp.toCharArray();
          }
         return password;
      }
   }

   static Principal getPrincipal()
   {
      Principal principal = (Principal) AccessController.doPrivileged(GetPrincipalAction.ACTION);
      return principal;
   }
   static char[] getCredential()
   {
      char[] credential = (char[]) AccessController.doPrivileged(GetCredentialAction.ACTION);
      return credential;
   }

}
