/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.resource.metadata;

import java.io.Serializable;
import java.util.Locale;

/**
 * License meta data
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class LicenseMetaData extends DescriptionMetaDataContainer
{
   // Constants -----------------------------------------------------

   // Attributes ----------------------------------------------------

   /** license required */
   private boolean required = false;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    * Get the license required flag
    * 
    * @return the license required flag
    */
   public boolean getRequired()
   {
      return required;
   }

   /**
    * Set the license required flag
    * 
    * @param required the required flag
    */
   public void setRequired(boolean required)
   {
      this.required = required;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();
      buffer.append("LicenseMetaData").append('@');
      buffer.append(Integer.toHexString(System.identityHashCode(this)));
      buffer.append("[required=").append(required);
      buffer.append(" descriptions=").append(getDescriptions());
      buffer.append(']');
      return buffer.toString();
   }
   
   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}
