/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.resource.adapter.mail;

import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;

import org.jboss.resource.adapter.mail.inflow.MailActivation;
import org.jboss.resource.adapter.mail.inflow.MailActivationSpec;
import org.jboss.resource.adapter.mail.inflow.NewMsgsWorker;
import org.jboss.logging.Logger;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class MailResourceAdapter
   implements ResourceAdapter
{
   private static Logger log = Logger.getLogger(MailResourceAdapter.class);

   private BootstrapContext ctx;
   /** The activations by activation spec */
   private ConcurrentReaderHashMap activations = new ConcurrentReaderHashMap();
   /** */
   private NewMsgsWorker newMsgsWorker;

   /**
    * Get the work manager
    * 
    * @return the work manager
    */
   public WorkManager getWorkManager()
   {
      return ctx.getWorkManager();
   }

   // --- Begin ResourceAdapter interface methods
   public void start(BootstrapContext ctx)
      throws ResourceAdapterInternalException
   {
      log.debug("start");
      this.ctx = ctx;
      WorkManager mgr = ctx.getWorkManager();
      newMsgsWorker = new NewMsgsWorker(mgr);
      try
      {
         mgr.scheduleWork(newMsgsWorker);
      }
      catch (WorkException e)
      {
         throw new ResourceAdapterInternalException(e);
      }
   }

   public void stop()
   {
      log.debug("stop");
      newMsgsWorker.release();
   }

   public void endpointActivation(MessageEndpointFactory endpointFactory,
      ActivationSpec spec)
      throws ResourceException
   {
      log.debug("endpointActivation, spec="+spec);
      MailActivationSpec mailSpec = (MailActivationSpec) spec;
      MailActivation activation = new MailActivation(this, endpointFactory,
         mailSpec);
      try
      {
         newMsgsWorker.watch(activation);
      }
      catch (InterruptedException e)
      {
         throw new ResourceException("Failed to schedule new msg check", e);
      }
      activations.put(spec, activation);
   }

   public void endpointDeactivation(MessageEndpointFactory endpointFactory,
      ActivationSpec spec)
   {
      log.debug("endpointDeactivation, spec="+spec);
      MailActivation activation = (MailActivation) activations.remove(spec);
      if (activation != null)
         activation.release();
   }

   public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException
   {
      return new XAResource[0];
   }
   // --- End ResourceAdapter interface methods

}
