/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.resource.adapter.jms;

import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

/**
 * A wrapper for a topic subscriber
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class JmsTopicSubscriber extends JmsMessageConsumer implements TopicSubscriber
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new wrapper
    * 
    * @param consumer the topic subscriber
    * @param session the session
    */
   public JmsTopicSubscriber(TopicSubscriber consumer, JmsSession session)
   {
      super(consumer, session);
   }
   
   // Public --------------------------------------------------------
   
   // TopicSubscriber implementation --------------------------------

   public boolean getNoLocal() throws JMSException
   {
      return ((TopicSubscriber) consumer).getNoLocal();
   }

   public Topic getTopic() throws JMSException
   {
      return ((TopicSubscriber) consumer).getTopic();
   }
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
