/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.transaction;

import org.jboss.logging.Logger;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.*;
import java.util.Properties;

/**
 * Basically a DummyTransactionManager to do batch mode processing.
 * @author bela
 * @version $Revision:1$
 *          Date: May 15, 2003
 *          Time: 4:11:37 PM
 */
public class BatchModeTransactionManager extends DummyBaseTransactionManager {
   static BatchModeTransactionManager instance=null;
   static Logger log=Logger.getLogger(BatchModeTransactionManager.class);

   public BatchModeTransactionManager() {
      ;
   }

   public static BatchModeTransactionManager getInstance() {
      if(instance == null) {
         instance=new BatchModeTransactionManager();
      }
      return instance;
   }

   public static void destroy() {
      if(instance == null) return;
      instance.setTransaction(null);
      instance=null;
   }

}
