/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;

import java.util.LinkedList;
import java.util.Iterator;

/**
 * @author Bela Ban
 * @version $Id:CopyOnWriteArrayTest.java,v 1.0, 2005-06-24 19:00:00Z, Robert Worsnop$
 */
public class CopyOnWriteArrayTest extends TestCase {
   LinkedList l;
   CopyOnWriteArrayList list;
   Exception thread_ex=null;

   protected void setUp() throws Exception {
      super.setUp();
      l=new LinkedList();
      l.add("one");
      l.add("two");
      l.add("three");
      list=new CopyOnWriteArrayList(l);
      thread_ex=null;
   }

   protected void tearDown() throws Exception {
      super.tearDown();
      if(thread_ex != null)
         throw thread_ex;
   }


   public void testInsertionandIteration() {
      Object el;
      System.out.println("list = " + list);

      Iterator it=list.iterator();
      System.out.println(it.next());

      list.add("four");

      int count=0;
      while(it.hasNext()) {
         el=it.next();
         System.out.println(el);
         ++count;
      }
      assertEquals(2, count);

      System.out.println("list: " + list);
      assertEquals(4, list.size());
   }





   public static Test suite() {
      return new TestSuite(CopyOnWriteArrayTest.class);
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
