/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Set;

import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;

/**
 * Implementation of the {@link org.jboss.cache.TreeCache}'s remote interface.
 * 
 * @author Daniel Gredler
 * @version $Id:RemoteTreeCacheImpl.java,v 1.0, 2005-06-24 19:14:58Z, Robert Worsnop$
 */
public class RemoteTreeCacheImpl extends UnicastRemoteObject implements RemoteTreeCache {

   private TreeCache cache;

   /**
    * @throws RemoteException
    */
   public RemoteTreeCacheImpl(TreeCache cache) throws RemoteException {
      this.cache=cache;
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#getChildrenNames(org.jboss.cache.Fqn)
    */
   public Set getChildrenNames(Fqn fqn) throws Exception, RemoteException {
      return this.cache.getChildrenNames(fqn);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#get(org.jboss.cache.Fqn, java.lang.Object)
    */
   public Object get(Fqn name, Object key) throws Exception, RemoteException {
      return this.cache.get(name, key);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#get(org.jboss.cache.Fqn)
    */
   public Node get(Fqn name) throws Exception, RemoteException {
      return this.cache.get(name);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#exists(org.jboss.cache.Fqn)
    */
   public boolean exists(Fqn name) throws Exception, RemoteException {
      return this.cache.exists(name);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#put(org.jboss.cache.Fqn, java.lang.Object, java.lang.Object)
    */
   public Object put(Fqn name, Object key, Object value) throws Exception, RemoteException {
      return this.cache.put(name, key, value);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#put(org.jboss.cache.Fqn, java.util.Map)
    */
   public void put(Fqn name, Map attributes) throws Exception, RemoteException {
      this.cache.put(name, attributes);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#remove(org.jboss.cache.Fqn, java.lang.Object)
    */
   public Object remove(Fqn name, Object key) throws Exception, RemoteException {
      return this.cache.remove(name, key);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#remove(org.jboss.cache.Fqn)
    */
   public void remove(Fqn name) throws Exception, RemoteException {
      this.cache.remove(name);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#removeData(org.jboss.cache.Fqn)
    */
   public void removeData(Fqn name) throws Exception, RemoteException {
      this.cache.removeData(name);
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#getState()
    */
   public byte[] getState() throws Exception, RemoteException {
      return this.cache.getStateBytes();
   }

   /**
    * @see org.jboss.cache.loader.rmi.RemoteTreeCache#setState(byte[])
    */
   public void setState(byte[] state) throws Exception, RemoteException {
      this.cache.setStateBytes(state);
   }

}
