/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 * Created on March 25 2003
 */
package org.jboss.cache.eviction;
import java.util.TimerTask;
import org.jboss.logging.Logger;

/**
 * Timer threads to do periodic node clean up by running the eviction policy.
 *
 * @author Ben Wang 2-2004
 */
public class EvictionTimerTask extends TimerTask
{
   private EvictionPolicy policy_;
   private Logger log_ = Logger.getLogger(EvictionTimerTask.class);

   public EvictionTimerTask(EvictionPolicy policy) {
      policy_ = policy;
   }

   public void run()
   {
      // TODO Let's safeguard timer comes in too often. But this can potentially overflow.
      synchronized(policy_) {
         Region[] regions = policy_.getRegions();
         for(int i=0; i < regions.length; i++) {
            Region region = regions[i];
            EvictionAlgorithm algo = region.getEvictionAlgorithm();
            try {
               algo.process(region);
            } catch (EvictionException e) {
               log_.error("run(): error processing eviction with exception: " +e.toString()
                     +" will reset the eviction queue list.");
               region.resetEvictionQueues();
               e.printStackTrace();
            }
         }
      }
   }
}
