/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.cache.eviction;

//import org.jboss.cache.TreeCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;

import java.util.Set;

/**
 * Generic eviction policy interface.
 *
 * @author Ben Wang 2-2004
 */
public interface EvictionPolicy
{
   /**
    * Return all regions declared.
    * @return
    */
   Region[] getRegions();

   /**
    * Evict a node form the underlying cache.
    * @param fqn Node corresponds to this fqn.
    * @throws Exception
    */
   void evict(Fqn fqn) throws Exception;

   /**
    * Return children names as Objects
    * @param fqn
    * @return
    */
   Set getChildrenNames(Fqn fqn);

   /**
    * Is this a leaf node?
    * @param fqn
    * @return
    */
   boolean hasChild(Fqn fqn);

   Object getCacheData(Fqn fqn, Object key);

   /**
    * return eviction thread (if any) wake up interval in seconds.
    * @return
    */
   int getWakeupIntervalSeconds();

   /**
    * Method called to configure this implementation.
    */
   void configure(TreeCache cache);
}
