/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;

public class HTTPServerInvoker
extends ServerInvoker
implements Runnable {
    private static int BACKLOG_DEFAULT = 1000;
    private static int MAX_POOL_SIZE_DEFAULT = 250;
    private ServerSocket serverSocket = null;
    private int serverBindPort = 8888;
    private InetAddress bindAddress = null;
    private boolean running = false;
    private Thread[] acceptThreads;
    private int numAcceptThreads = 1;
    private PooledExecutor threadpool;
    private int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    private String serverBindAddress = "localhost";
    protected int backlog = BACKLOG_DEFAULT;
    public static String HTML = "text/html";
    public static String PLAIN = "text/plain";
    public static String SOAP = "application/soap+xml";
    public static String BINARY = "application/octet-stream";
    public static String HEADER_SESSION_ID = "sessionId";
    public static String HEADER_SUBSYSTEM = "subsystem";

    public HTTPServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public boolean isTransportBiDirectional() {
        return false;
    }

    public void start() throws IOException {
        if (!this.running) {
            this.running = true;
            try {
                this.threadpool = new PooledExecutor((Channel)new BoundedBuffer(this.maxPoolSize));
                this.threadpool.waitWhenBlocked();
                this.bindAddress = InetAddress.getByName(this.serverBindAddress);
                this.serverBindPort = this.getLocator().getPort();
                this.serverSocket = new ServerSocket(this.serverBindPort, this.backlog, this.bindAddress);
                this.acceptThreads = new Thread[this.numAcceptThreads];
                for (int i = 0; i < this.numAcceptThreads; ++i) {
                    String name = "HTTPServerInvoker#" + i + "-" + this.serverBindPort;
                    this.acceptThreads[i] = new Thread((Runnable)this, name);
                    this.acceptThreads[i].start();
                }
            }
            catch (IOException e) {
                this.log.error((Object)("Error starting ServerSocket.  Bind port: " + this.serverBindPort + ", bind address: " + this.bindAddress));
                throw e;
            }
        }
        super.start();
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.getPoolSize();
    }

    public void run() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                if (socket == null) continue;
                HTTPServerWorker worker = new HTTPServerWorker(socket);
                try {
                    this.threadpool.execute((Runnable)worker);
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"HTTP server worker thread interrupted.", (Throwable)e);
                }
            }
            catch (Throwable thr) {
                this.log.error((Object)"Error processing incoming request.", thr);
            }
        }
    }

    private int getContentLength(Object response) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(response);
        oos.flush();
        bos.flush();
        byte[] buffer = bos.toByteArray();
        return buffer.length;
    }

    private InvocationRequest getInvocationRequest(Map metadata, Object obj) {
        InvocationRequest request = null;
        if (obj instanceof InvocationRequest) {
            request = (InvocationRequest)obj;
            if (request.getRequestPayload() == null) {
                request.setRequestPayload(metadata);
            } else {
                request.getRequestPayload().putAll(metadata);
            }
        } else {
            request = this.createNewInvocationRequest(metadata, obj);
        }
        return request;
    }

    private InvocationRequest createNewInvocationRequest(Map metadata, Object payload) {
        String sessionId = this.getSessionId(metadata);
        String subSystem = (String)metadata.get(HEADER_SUBSYSTEM);
        InvocationRequest request = new InvocationRequest(sessionId, subSystem, payload, metadata, null, null);
        return request;
    }

    private String getSessionId(Map metadata) {
        String sessionId = (String)metadata.get(HEADER_SESSION_ID);
        if (sessionId == null || sessionId.length() == 0) {
            String userAgent = (String)metadata.get("User-Agent");
            String host = (String)metadata.get("Host");
            String idSeed = userAgent + ":" + host;
            sessionId = Integer.toString(idSeed.hashCode());
        }
        return sessionId;
    }

    private boolean isBinary(String requestContentType) {
        return BINARY.equalsIgnoreCase(requestContentType);
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.maxPoolSize = 0;
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                try {
                    this.acceptThreads[i].interrupt();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.threadpool.shutdownAfterProcessingCurrentlyQueuedTasks();
                this.threadpool.awaitTerminationAfterShutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
                this.serverSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.stop();
        this.log.debug((Object)"HTTPServerInvoker stopped.");
    }

    public String getMBeanObjectName() {
        return "jboss.remoting:service=invoker,transport=http";
    }

    private class HTTPServerWorker
    implements Runnable {
        private Socket socket;

        public HTTPServerWorker(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            try {
                this.processRequest(this.socket);
            }
            catch (Throwable e) {
                HTTPServerInvoker.this.log.error((Object)("Error processing http request in HTTPServerInvoker::HTTPServerWorker " + Thread.currentThread().getName()), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void processRequest(Socket socket) {
            block35: {
                Exception e2222;
                FilterOutputStream dataOutput;
                FilterInputStream dataInput;
                block31: {
                    block30: {
                        dataInput = null;
                        dataOutput = null;
                        FilterOutputStream bufferOutput = null;
                        Object response = null;
                        boolean isError = false;
                        String requestContentType = null;
                        try {
                            int ch;
                            dataInput = new DataInputStream(socket.getInputStream());
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            while ((ch = dataInput.read()) >= 0) {
                                buffer.write(ch);
                                if (ch != 10) continue;
                            }
                            String methodType = null;
                            String path = null;
                            String httpVersion = null;
                            byte[] firstLineRaw = buffer.toByteArray();
                            if (firstLineRaw[firstLineRaw.length - 2] != 13) {
                                System.err.println("Error processing first line.  Should have ended in \r\n, but did not");
                                throw new RuntimeException("Error processing HTTP request type.  First line of request is invalid.");
                            }
                            String firstLine = new String(firstLineRaw).trim();
                            int startIndex = 0;
                            int endIndex = firstLine.indexOf(32);
                            methodType = firstLine.substring(startIndex, endIndex);
                            startIndex = endIndex + 1;
                            endIndex = firstLine.indexOf(32, startIndex);
                            path = firstLine.substring(startIndex, endIndex);
                            startIndex = endIndex + 1;
                            httpVersion = firstLine.substring(startIndex);
                            HashMap<String, String> metadata = new HashMap<String, String>();
                            Header[] headers = HttpParser.parseHeaders((InputStream)dataInput);
                            for (int x = 0; x < headers.length; ++x) {
                                String headerName = headers[x].getName();
                                String headerValue = headers[x].getName();
                                metadata.put(headerName, headerValue);
                                if (!"Content-Type".equalsIgnoreCase(headerName)) continue;
                                requestContentType = headers[x].getValue();
                            }
                            UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller("http");
                            Object obj = unmarshaller.read(dataInput, metadata);
                            InvocationRequest request = null;
                            request = obj instanceof InvocationRequest ? (InvocationRequest)obj : (HTTPServerInvoker.this.isBinary(requestContentType) ? HTTPServerInvoker.this.getInvocationRequest(metadata, obj) : HTTPServerInvoker.this.createNewInvocationRequest(metadata, obj));
                            try {
                                response = HTTPServerInvoker.this.invoke(request);
                            }
                            catch (Throwable ex) {
                                HTTPServerInvoker.this.log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                                response = ex;
                                isError = true;
                            }
                            dataOutput = new DataOutputStream(socket.getOutputStream());
                            bufferOutput = new BufferedOutputStream(dataOutput, 1024);
                        }
                        catch (Throwable thr) {
                            HTTPServerInvoker.this.log.debug((Object)"Error thrown processing request.  Probably error with processing headers.", thr);
                            response = thr instanceof Exception ? (Exception)thr : new Exception(thr);
                            isError = true;
                        }
                        if (response == null) {
                            bufferOutput.write("HTTP/1.1 ".getBytes());
                            bufferOutput.write("200 JBoss Remoting: Request Processed Successfully".getBytes());
                            String contentType = "\r\nContent-Type: text/html";
                            bufferOutput.write(contentType.getBytes());
                            String contentLength = "\r\nContent-Length: 0";
                            bufferOutput.write(contentLength.getBytes());
                            ((BufferedOutputStream)bufferOutput).flush();
                            break block30;
                        }
                        bufferOutput.write("HTTP/1.1 ".getBytes());
                        String status = isError ? "500 JBoss Remoting: Error occurred within target application." : "200 JBoss Remoting: Request Processed Succussfully";
                        bufferOutput.write(status.getBytes());
                        String contentType = "\r\nContent-Type: " + requestContentType;
                        bufferOutput.write(contentType.getBytes());
                        int iContentLength = HTTPServerInvoker.this.getContentLength(response);
                        String contentLength = "\r\nContent-Length: " + iContentLength;
                        bufferOutput.write(contentLength.getBytes());
                        bufferOutput.write("\r\n\r\n".getBytes());
                        Marshaller marshaller = MarshalFactory.getMarshaller(HTTPServerInvoker.this.getLocator(), this.getClass().getClassLoader());
                        if (marshaller == null) {
                            marshaller = MarshalFactory.getMarshaller("http");
                        }
                        marshaller.write(response, bufferOutput);
                    }
                    Object var21_27 = null;
                    if (dataInput == null) break block31;
                    try {
                        dataInput.close();
                    }
                    catch (Exception e2222) {
                        HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                    }
                }
                if (dataOutput != null) {
                    try {
                        dataOutput.close();
                    }
                    catch (Exception e2222) {
                        HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                    }
                }
                try {
                    socket.close();
                }
                catch (Exception e2222) {
                    HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                }
                break block35;
                {
                    catch (Exception e3) {
                        HTTPServerInvoker.this.log.error((Object)"Error processing client request.", (Throwable)e3);
                        Object var21_28 = null;
                        if (dataInput != null) {
                            try {
                                dataInput.close();
                            }
                            catch (Exception e2222) {
                                HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                            }
                        }
                        if (dataOutput != null) {
                            try {
                                dataOutput.close();
                            }
                            catch (Exception e2222) {
                                HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (Exception e2222) {
                            HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var21_29 = null;
                    if (dataInput != null) {
                        try {
                            dataInput.close();
                        }
                        catch (Exception e2222) {
                            HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                        }
                    }
                    if (dataOutput != null) {
                        try {
                            dataOutput.close();
                        }
                        catch (Exception e2222) {
                            HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                        }
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e2222) {
                        HTTPServerInvoker.this.log.warn((Object)"Error closing resource.", (Throwable)e2222);
                    }
                    throw throwable;
                }
            }
        }
    }
}

