/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection.multicast;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.detection.AbstractDetector;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.multicast.MulticastDetectorMBean;
import org.jboss.remoting.ident.Identity;

public class MulticastDetector
extends AbstractDetector
implements MulticastDetectorMBean {
    private String defaultIP = "224.1.9.1";
    private InetAddress addr;
    private InetAddress bindAddr;
    private int port = 2410;
    private MulticastSocket socket;
    private Listener listener = new Listener();

    public String getDefaultIP() {
        return this.defaultIP;
    }

    public void setDefaultIP(String defaultIP) {
        this.defaultIP = defaultIP;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public void setAddress(InetAddress ip) {
        this.addr = ip;
    }

    public InetAddress getBindAddress() {
        return this.bindAddr;
    }

    public void setBindAddress(InetAddress ip) {
        this.bindAddr = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        if (this.addr == null) {
            this.addr = InetAddress.getByName(this.defaultIP);
        }
        InetAddress localHost = InetAddress.getLocalHost();
        if (this.bindAddr == null && localHost.getHostAddress().equals("127.0.0.1")) {
            this.bindAddr = localHost;
        }
        this.socket = new MulticastSocket(this.port);
        if (this.bindAddr != null) {
            this.socket.setInterface(this.bindAddr);
        }
        this.socket.joinGroup(this.addr);
        super.start();
        if (this.listener == null) {
            this.listener = new Listener();
        }
        this.listener.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.listener.running = false;
        this.listener.interrupt();
        this.listener = null;
        this.socket.leaveGroup(this.addr);
        this.socket.close();
        this.socket = null;
    }

    protected void heartbeat() {
        ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
        if (invokers == null || invokers.length <= 0) {
            return;
        }
        ArrayList<InvokerLocator> l = new ArrayList<InvokerLocator>(invokers.length);
        for (int c = 0; c < invokers.length; ++c) {
            if (!invokers[c].isStarted()) continue;
            l.add(invokers[c].getLocator());
        }
        if (l.isEmpty()) {
            return;
        }
        InvokerLocator[] locators = l.toArray(new InvokerLocator[l.size()]);
        if (this.socket != null) {
            Detection msg = new Detection(Identity.get(this.mbeanserver), locators);
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("sending heartbeat: " + msg));
                }
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
                objectOut.writeObject(msg);
                objectOut.flush();
                byteOut.flush();
                byte[] buf = byteOut.toByteArray();
                DatagramPacket p = new DatagramPacket(buf, buf.length, this.addr, this.port);
                this.socket.send(p);
            }
            catch (Throwable ex) {
                this.log.debug((Object)"heartbeat failed", ex);
            }
        }
    }

    private void listen(DatagramPacket p, byte[] buf) {
        block5: {
            if (this.socket != null) {
                try {
                    this.socket.receive(p);
                    ByteArrayInputStream byteInput = new ByteArrayInputStream(buf);
                    ObjectInputStream objectInput = new ObjectInputStream(byteInput);
                    Detection msg = (Detection)objectInput.readObject();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("received detection: " + msg));
                    }
                    this.detect(msg);
                }
                catch (Throwable e) {
                    if (e instanceof InvalidClassException) {
                        return;
                    }
                    if (this.socket == null) break block5;
                    this.log.debug((Object)"Error receiving detection", e);
                }
            }
        }
    }

    private final class Listener
    extends Thread {
        boolean running = true;

        private Listener() {
        }

        public void run() {
            byte[] buf = new byte[4000];
            DatagramPacket p = new DatagramPacket(buf, 0, buf.length);
            while (this.running) {
                MulticastDetector.this.listen(p, buf);
            }
        }
    }
}

