/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvokerCallbackHandler;
import org.jboss.remoting.ServerInvokerMBean;
import org.jboss.remoting.SubsystemNotSupported;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.loading.ClassBytes;

public abstract class ServerInvoker
extends AbstractInvoker
implements ServerInvokerMBean {
    public static final int MAX_NUM_ONEWAY_THREADS = 100;
    protected Map handlers = new HashMap();
    protected Map callbackHandlers = new HashMap();
    private Map clientCallbackListener = new HashMap();
    private boolean started = false;
    private static PooledExecutor onewayExecutor;
    private static int onewayThreadCounter;
    private MBeanServer mbeanServer = null;
    private Map configuration = new HashMap();
    private String dataType;

    public ServerInvoker(InvokerLocator locator) {
        super(locator);
        Map params = locator.getParameters();
        if (this.configuration != null && params != null) {
            this.configuration.putAll(locator.getParameters());
        }
    }

    public ServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator);
        this.configuration = configuration;
        Map locatorParams = locator.getParameters();
        if (configuration != null && locatorParams != null) {
            configuration.putAll(locator.getParameters());
        }
    }

    private static synchronized Executor getOnewayExecutor() {
        if (onewayExecutor == null) {
            onewayExecutor = new PooledExecutor(100);
            onewayExecutor.setKeepAliveTime(3000L);
            onewayExecutor.waitWhenBlocked();
            onewayExecutor.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "Remoting server oneway " + onewayThreadCounter++);
                }
            });
        }
        return onewayExecutor;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    public synchronized boolean hasInvocationHandler(String subsystem) {
        return this.handlers.containsKey(subsystem);
    }

    public synchronized String[] getSupportedSubsystems() {
        String[] subsystems = new String[this.handlers.size()];
        return this.handlers.keySet().toArray(subsystems);
    }

    public synchronized ServerInvocationHandler[] getInvocationHandlers() {
        ServerInvocationHandler[] ih = new ServerInvocationHandler[this.handlers.size()];
        return this.handlers.values().toArray(ih);
    }

    public synchronized void addInvocationHandler(String subsystem, ServerInvocationHandler handler) {
        handler.setInvoker(this);
        this.handlers.put(subsystem.toUpperCase(), handler);
    }

    public synchronized ServerInvocationHandler removeInvocationHandler(String subsystem) {
        return (ServerInvocationHandler)this.handlers.remove(subsystem.toUpperCase());
    }

    public synchronized ServerInvocationHandler getInvocationHandler(String subsystem) {
        return (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
    }

    public Object invoke(Object invoke) throws IOException {
        InvocationRequest request = null;
        InvocationResponse response = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("server received invocation =>" + invoke));
        }
        if (invoke != null && invoke instanceof InvocationRequest) {
            request = (InvocationRequest)invoke;
            try {
                if ("$PING$".equals(request.getParameter())) {
                    return new InvocationResponse(request.getSessionId(), Boolean.TRUE, false, null);
                }
                Object result = this.invoke(request);
                response = new InvocationResponse(request.getSessionId(), result, false, request.getReturnPayload());
            }
            catch (Throwable throwable) {
                if (this.log.isDebugEnabled()) {
                    throwable.printStackTrace();
                }
                response = new InvocationResponse(request.getSessionId(), throwable, true, request.getReturnPayload());
            }
        } else {
            this.log.error((Object)("server invoker received " + invoke + " as invocation.  Must not be null and must be of type InvocationRequest."));
            response = new InvocationResponse(request.getSessionId(), new Exception("Error processing invocation request on " + this.getLocator() + ".  Either invocation was null or of wrong type."), true, request.getReturnPayload());
        }
        return response;
    }

    public String getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getLocator());
            if (this.dataType == null) {
                this.dataType = this.getDefaultDataType();
            }
        }
        return this.dataType;
    }

    private String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            type = (String)params.get("datatype");
        }
        return type;
    }

    protected abstract String getDefaultDataType();

    public Object invoke(InvocationRequest invocation) throws Throwable {
        Object param = invocation.getParameter();
        Object result = null;
        if (param instanceof OnewayInvocation) {
            this.handleOnewayInvocation((OnewayInvocation)param, invocation);
        } else {
            String subsystem = invocation.getSubsystem();
            InvokerLocator client = invocation.getLocator();
            ServerInvocationHandler handler = null;
            if (subsystem != null) {
                handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
            } else if (!this.handlers.isEmpty()) {
                handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
            } else {
                throw new RuntimeException("Can not find a subsystem handler to take invocation request.");
            }
            if (handler == null) {
                throw new SubsystemNotSupported(subsystem, this.locator);
            }
            if (param instanceof InternalInvocation) {
                result = this.handleInternalInvocation((InternalInvocation)param, invocation, handler);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("dispatching invocation: " + invocation + " to subsystem: " + subsystem + " from client: " + client));
                }
                result = handler.invoke(invocation);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("dispatch invocation, returning back: " + result + " from subsystem: " + subsystem + " to client: " + client));
            }
        }
        return result;
    }

    private void handleOnewayInvocation(OnewayInvocation onewayInvocation, InvocationRequest invocation) throws Throwable {
        Object[] objs = onewayInvocation.getParameters();
        Object realParam = objs[0];
        invocation.setParameter(realParam);
        final InvocationRequest newInvocation = invocation;
        Executor executor = ServerInvoker.getOnewayExecutor();
        Runnable onewayRun = new Runnable(){

            public void run() {
                try {
                    ServerInvoker.this.invoke(newInvocation);
                }
                catch (Throwable e) {
                    ServerInvoker.this.log.error((Object)("Error executing server oneway invocation request: " + newInvocation), e);
                }
            }
        };
        executor.execute(onewayRun);
    }

    private Object handleInternalInvocation(InternalInvocation param, InvocationRequest invocation, ServerInvocationHandler handler) throws Throwable {
        List result = null;
        String methodName = param.getMethodName();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("handling InternalInvocation where method name = " + methodName));
        }
        if ("addListener".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            handler.addListener(callbackHandler);
        } else if ("removeListener".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.removeCallbackHandler(invocation);
            if (callbackHandler != null) {
                handler.removeListener(callbackHandler);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("ServerInvoker (" + this + ") removing server callback handler " + callbackHandler + "."));
                }
                callbackHandler.destroy();
            }
        } else if ("getCallbacks".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ServerInvoker (" + this + ") getting callbacks for callback handler " + callbackHandler + "."));
            }
            result = callbackHandler.getCallbacks();
        } else if ("addClientListener".equals(methodName)) {
            String sessionId = invocation.getSessionId();
            Object[] params = param.getParameters();
            if (params == null || params.length < 0 || params.length > 3) {
                this.log.error((Object)("Recieved addClientListener InternalInvocation, but getParameters() returned: " + params));
                throw new RuntimeException("InvokerCallbackHandler and callback handle object (optional) must be supplied as the only parameter objects within the InternalInvocation when calling addClientListener.");
            }
            InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)params[0];
            Object callbackHandleObject = params[1];
            CallbackContainer callbackContainer = new CallbackContainer(callbackHandler, callbackHandleObject);
            this.clientCallbackListener.put(sessionId, callbackContainer);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ServerInvoker (" + this + ") added client callback handler " + callbackHandler + " with session id of " + sessionId + " and callback handle object of " + callbackHandleObject + "."));
            }
        } else if ("removeClientListener".equals(methodName)) {
            String sessionId = invocation.getSessionId();
            this.clientCallbackListener.remove(sessionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ServerInvoker (" + this + ") removing client callback handler with session id of " + sessionId + "."));
            }
        } else if ("handleCallback".equals(methodName)) {
            CallbackContainer callbackContainer;
            String sessionId = invocation.getSessionId();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ServerInvoker (" + this + ") is being asked to deliver callback on client callback handler with session id of " + sessionId + "."));
            }
            if ((callbackContainer = (CallbackContainer)this.clientCallbackListener.get(sessionId)) != null && callbackContainer.getCallbackHandler() != null) {
                Object[] params = param.getParameters();
                InvocationRequest callbackRequest = (InvocationRequest)params[0];
                HashMap<String, Object> callbackHandleObject = callbackRequest.getReturnPayload();
                if (callbackHandleObject == null) {
                    callbackHandleObject = new HashMap<String, Object>();
                }
                callbackHandleObject.put("callback_handle_object", callbackContainer.getCallbackHandleObject());
                callbackRequest.setReturnPayload(callbackHandleObject);
                InvokerCallbackHandler callbackHandler = callbackContainer.getCallbackHandler();
                callbackHandler.handleCallback(callbackRequest);
            } else {
                this.log.error((Object)("Could not find callback handler to call upon for handleCallback where session id equals " + sessionId));
            }
        } else {
            this.log.error((Object)("Error processing InternalInvocation.  Unable to process method " + methodName + ".  Please make sure this should be an InternalInvocation."));
            throw new RuntimeException("Error processing InternalInvocation.  Unable to process method " + methodName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInvokerCallbackHandler getCallbackHandler(InvocationRequest invocation) throws Exception {
        ServerInvokerCallbackHandler callbackHandler = null;
        String id = ServerInvokerCallbackHandler.getId(invocation);
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(id);
            if (callbackHandler == null) {
                callbackHandler = new ServerInvokerCallbackHandler(invocation, this.getLocator(), this);
                this.callbackHandlers.put(id, callbackHandler);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("ServerInvoker (" + this + ") adding server callback handler " + callbackHandler + " with id of " + id + "."));
        }
        return callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInvokerCallbackHandler removeCallbackHandler(InvocationRequest invocation) {
        String id = ServerInvokerCallbackHandler.getId(invocation);
        ServerInvokerCallbackHandler callbackHandler = null;
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.remove(id);
        }
        return callbackHandler;
    }

    protected void preProcess(String sessionId, ClassBytes arg, Map payload, InvokerLocator locator) {
    }

    protected void postProcess(String sessionId, Object param, Map payload, InvokerLocator locator) {
    }

    public void start() throws IOException {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.started = false;
    }

    public void destroy() {
        if (this.classbyteloader != null) {
            this.classbyteloader.destroy();
        }
    }

    public void setConfigration(Map configuration) {
        this.configuration = configuration;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public abstract String getMBeanObjectName();

    static {
        onewayThreadCounter = 0;
    }

    private class CallbackContainer {
        private InvokerCallbackHandler handler;
        private Object handleObject;

        public CallbackContainer(InvokerCallbackHandler handler, Object handleObject) {
            this.handler = handler;
            this.handleObject = handleObject;
        }

        public InvokerCallbackHandler getCallbackHandler() {
            return this.handler;
        }

        public Object getCallbackHandleObject() {
            return this.handleObject;
        }
    }
}

