/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.http.HTTPClientInvoker;
import org.jboss.remoting.transport.http.HTTPServerInvoker;
import org.jboss.remoting.transport.local.LocalClientInvoker;
import org.jboss.remoting.transport.rmi.RMIClientInvoker;
import org.jboss.remoting.transport.rmi.RMIServerInvoker;
import org.jboss.remoting.transport.socket.SocketClientInvoker;
import org.jboss.remoting.transport.socket.SocketServerInvoker;

public class InvokerRegistry {
    private static final Logger log = Logger.getLogger((Class)InvokerRegistry.class);
    private static final Map clientInvokers = new HashMap();
    private static final Map serverInvokers = new HashMap();
    private static final Map clientLocators = new HashMap();
    private static final Map serverLocators = new HashMap();
    private static final Set registeredLocators = new HashSet();
    private static final Object serverLock = new Object();
    private static final Object clientLock = new Object();

    public static final synchronized InvokerLocator[] getRegisteredServerLocators() {
        return registeredLocators.toArray(new InvokerLocator[registeredLocators.size()]);
    }

    public static synchronized InvokerLocator getSuitableServerLocatorForRemote(InvokerLocator remote) {
        Iterator iter = registeredLocators.iterator();
        while (iter.hasNext()) {
            InvokerLocator l = (InvokerLocator)iter.next();
            if (!l.getProtocol().equals(remote.getProtocol())) continue;
            return l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getRegisteredInvokerTransports() {
        Object object = clientLock;
        synchronized (object) {
            Set set = clientInvokers.keySet();
            String[] transports = new String[set.size()];
            return set.toArray(transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ClientInvoker[] getClientInvokers() {
        Object object = clientLock;
        synchronized (object) {
            if (clientLocators.isEmpty()) {
                return new ClientInvoker[0];
            }
            Collection collection = clientLocators.values();
            return collection.toArray(new RemoteClientInvoker[collection.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ServerInvoker[] getServerInvokers() {
        Object object = serverLock;
        synchronized (object) {
            if (serverLocators.isEmpty()) {
                return new ServerInvoker[0];
            }
            Collection collection = serverLocators.values();
            return collection.toArray(new ServerInvoker[collection.size()]);
        }
    }

    public static synchronized void registerInvoker(String transport, Class client, Class server) {
        clientInvokers.put(transport, client);
        serverInvokers.put(transport, server);
    }

    public static synchronized void unregisterInvoker(String transport) {
        clientInvokers.remove(transport);
        serverInvokers.remove(transport);
    }

    public static synchronized void unregisterLocator(InvokerLocator locator) {
        serverLocators.remove(locator);
        registeredLocators.remove(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClientInvokerRegistered(InvokerLocator locator) {
        Object object = clientLock;
        synchronized (object) {
            return clientLocators.containsKey(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyClientInvoker(InvokerLocator locator) {
        ClientInvoker invoker = null;
        Object object = clientLock;
        synchronized (object) {
            invoker = (ClientInvoker)clientLocators.remove(locator);
        }
        if (invoker != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("destroying client for locator: " + locator + ", invoker:" + invoker + ", remaining list:" + clientLocators));
            }
            invoker.disconnect();
            invoker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientInvoker createClientInvoker(InvokerLocator locator) throws Exception {
        if (locator == null) {
            throw new NullPointerException("locator cannot be null");
        }
        Object object = clientLock;
        synchronized (object) {
            ServerInvoker svrInvoker;
            String value;
            ClientInvoker invoker = (ClientInvoker)clientLocators.get(locator);
            if (invoker != null) {
                return invoker;
            }
            boolean isPassByValue = false;
            Map parameters = locator.getParameters();
            if (parameters != null && (value = (String)parameters.get("byvalue")) != null && Boolean.valueOf(value).booleanValue()) {
                isPassByValue = true;
            }
            if ((svrInvoker = (ServerInvoker)serverLocators.get(locator)) != null && !isPassByValue) {
                LocalClientInvoker localInvoker = new LocalClientInvoker(locator);
                localInvoker.setServerInvoker(svrInvoker);
                invoker = localInvoker;
                InvokerLocator l = invoker.getLocator();
                clientLocators.put(l, invoker);
            } else {
                String protocol = locator.getProtocol();
                if (protocol == null) {
                    throw new NullPointerException("protocol cannot be null for the locator");
                }
                Class cl = (Class)clientInvokers.get(protocol);
                if (cl == null) {
                    throw new RuntimeException("Couldn't find valid client invoker class for transport '" + protocol + "'");
                }
                Constructor ctor = cl.getConstructor(InvokerLocator.class);
                invoker = (ClientInvoker)ctor.newInstance(locator);
                InvokerLocator l = invoker.getLocator();
                clientLocators.put(l, invoker);
            }
            return invoker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerInvokerRegistered(InvokerLocator locator) {
        Object object = serverLock;
        synchronized (object) {
            return serverLocators.containsKey(locator);
        }
    }

    public static ServerInvoker createServerInvoker(InvokerLocator locator) throws Exception {
        return InvokerRegistry.createServerInvoker(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerInvoker createServerInvoker(InvokerLocator locator, Map configuration) throws Exception {
        ServerInvoker invoker = null;
        Object object = serverLock;
        synchronized (object) {
            invoker = (ServerInvoker)serverLocators.get(locator);
            if (invoker != null) {
                return invoker;
            }
            Class cl = (Class)serverInvokers.get(locator.getProtocol());
            if (cl == null) {
                throw new RuntimeException("Couldn't find valid server invoker class for transport '" + locator.getProtocol() + "'");
            }
            if (configuration != null) {
                Constructor ctor = cl.getConstructor(InvokerLocator.class, Map.class);
                invoker = (ServerInvoker)ctor.newInstance(locator, configuration);
            } else {
                Constructor ctor = cl.getConstructor(InvokerLocator.class);
                invoker = (ServerInvoker)ctor.newInstance(locator);
            }
            serverLocators.put(locator, invoker);
            registeredLocators.add(invoker.getLocator());
        }
        try {
            return invoker;
        }
        catch (Exception ex) {
            serverLocators.remove(locator);
            registeredLocators.remove(locator);
            throw ex;
        }
    }

    static {
        InvokerRegistry.registerInvoker("socket", SocketClientInvoker.class, SocketServerInvoker.class);
        InvokerRegistry.registerInvoker("rmi", RMIClientInvoker.class, RMIServerInvoker.class);
        InvokerRegistry.registerInvoker("http", HTTPClientInvoker.class, HTTPServerInvoker.class);
    }
}

