/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.system.server.ServerConfigUtil;

public class InvokerLocator
implements Serializable {
    private static final long serialVersionUID = -2909329895029296248L;
    protected String protocol;
    protected String host;
    protected int port;
    protected String path;
    protected Map parameters;
    private String uri;
    private String originalURL;
    public static final String DATATYPE = "datatype";
    public static final String DATATYPE_CASED = "dataType";
    public static final String MARSHALLER = "marshaller";
    public static final String UNMARSHALLER = "unmarshaller";
    public static final String LOADER_PORT = "loaderport";
    public static final String BYVALUE = "byvalue";

    public InvokerLocator(String uri) throws MalformedURLException {
        this.originalURL = uri;
        int i = uri.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException();
        }
        String tmp = uri.substring(i + 3);
        this.protocol = uri.substring(0, i);
        i = tmp.indexOf("/");
        int p = tmp.indexOf(":");
        if (p != -1) {
            this.host = InvokerLocator.resolveHost(tmp.substring(0, p).trim());
            this.port = i > -1 ? Integer.parseInt(tmp.substring(p + 1, i)) : Integer.parseInt(tmp.substring(p + 1));
        } else {
            this.host = i > -1 ? InvokerLocator.resolveHost(tmp.substring(0, i).trim()) : InvokerLocator.resolveHost(tmp.substring(0).trim());
            this.port = -1;
        }
        p = tmp.indexOf("?");
        if (p != -1) {
            this.path = tmp.substring(i + 1, p);
            String args = tmp.substring(p + 1);
            StringTokenizer tok = new StringTokenizer(args, "&");
            this.parameters = new HashMap(tok.countTokens());
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int eq = token.indexOf("=");
                String name = eq > -1 ? token.substring(0, eq) : token;
                String value = eq > -1 ? token.substring(eq + 1) : "";
                this.parameters.put(name, value);
            }
        } else {
            this.path = "";
        }
        this.uri = this.protocol + "://" + this.host + (this.port > -1 ? ":" + this.port : "") + "/" + this.path + (this.parameters != null ? "?" : "");
        if (this.parameters != null) {
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.parameters.get(key);
                this.uri = this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
        }
    }

    private static final String resolveHost(String host) {
        if (host.indexOf("0.0.0.0") != -1) {
            host = System.getProperty("jboss.bind.address", "0.0.0.0").equals("0.0.0.0") ? ServerConfigUtil.fixRemoteAddress((String)host) : host.replaceAll("0\\.0\\.0\\.0", System.getProperty("jboss.bind.address"));
        }
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception ex) {
            return host;
        }
    }

    public InvokerLocator(String protocol, String host, int port, String path, Map parameters) {
        this.protocol = protocol;
        this.host = InvokerLocator.resolveHost(host);
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.uri = protocol + "://" + this.host + (port > -1 ? ":" + port : "") + "/" + path + (parameters != null ? "?" : "");
        if (parameters != null) {
            Iterator iter = parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)parameters.get(key);
                this.uri = this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
        }
        this.originalURL = this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof InvokerLocator && obj.hashCode() == this.hashCode();
    }

    public String getLocatorURI() {
        return this.uri;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "InvokerLocator [" + this.uri + "]";
    }

    public String getOriginalURI() {
        return this.originalURL;
    }

    public ClientInvoker narrow() throws Exception {
        return InvokerRegistry.createClientInvoker(this);
    }
}

