/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Serializable;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.remoting.ClientInterceptor;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.util.id.GUID;

public class ClientInvokerAdapter
implements ClientInterceptor,
Serializable {
    static final long serialVersionUID = -1795129092816780782L;
    private static Logger log = Logger.getLogger((Class)ClientInvokerAdapter.class);
    transient ClassLoader cl;
    String internalSessionId = new GUID().toString();

    public ClientInvokerAdapter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClientInvokerAdapter(ClassLoader cl) {
        this.cl = cl;
    }

    public void addListener(InvokerLocator locator, String subsystem, InvokerCallbackHandler callbackHandler) throws Throwable {
        ClientInvoker invoker = this.getClientInvoker(locator);
        InvokerLocator clientLocator = invoker.getClientLocator();
        if (clientLocator != null) {
            this.connect(clientLocator);
            this.invoke(new InvocationRequest(this.internalSessionId, subsystem, new InternalInvocation("addClientListener", new Object[]{callbackHandler}), null, null, clientLocator));
            this.disconnect(clientLocator);
        }
        this.invoke(new InvocationRequest(this.internalSessionId, subsystem, new InternalInvocation("addListener", null), null, null, locator));
    }

    public void removeListener(InvokerLocator locator, String subsystem, InvokerCallbackHandler callbackHandler) throws Throwable {
        ClientInvoker invoker = this.getClientInvoker(locator);
        InvokerLocator clientLocator = invoker.getClientLocator();
        if (clientLocator != null) {
            this.connect(clientLocator);
            this.invoke(new InvocationRequest(this.internalSessionId, subsystem, new InternalInvocation("removeClientListener", new Object[]{callbackHandler}), null, null, clientLocator));
            this.disconnect(clientLocator);
        }
        this.invoke(new InvocationRequest(this.internalSessionId, subsystem, new InternalInvocation("removeListener", null), null, null, locator));
    }

    public List getCallbacks(InvokerLocator locator, String subsystem) throws Throwable {
        return (List)this.invoke(new InvocationRequest(this.internalSessionId, subsystem, new InternalInvocation("getCallbacks", null), null, null, locator));
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        ClientInvoker invoker = this.getClientInvoker(invocation.getLocator());
        if (!invoker.isConnected()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("invoke called, but our invoker is disconnected, discarding and fetching another fresh invoker for: " + invoker.getLocator()));
            }
            invoker.connect();
        }
        return invoker.invoke(invocation);
    }

    public void connect(InvokerLocator locator) throws Exception {
        ClientInvoker invoker = this.getClientInvoker(locator);
        invoker.connect();
    }

    public boolean isConnected(InvokerLocator locator) throws Exception {
        ClientInvoker invoker = this.getClientInvoker(locator);
        return invoker.isConnected();
    }

    public void disconnect(InvokerLocator locator) throws Exception {
        ClientInvoker invoker = this.getClientInvoker(locator);
        invoker.disconnect();
    }

    protected ClientInvoker getClientInvoker(InvokerLocator locator) throws Exception {
        return InvokerRegistry.createClientInvoker(locator);
    }
}

