/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

public class DatabaseScript {
    public static Result getScript(Database database, boolean bl) {
        int n;
        int n2;
        String string;
        Object object;
        CharSequence charSequence;
        Object object2;
        int n3;
        HsqlArrayList hsqlArrayList = database.getTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        Result result = Result.newSingleColumnResult("COMMAND", 12);
        result.metaData.tableNames[0] = "SYSTEM_SCRIPT";
        HashMappedList hashMappedList = database.sequenceManager.sequenceMap;
        int n4 = hashMappedList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (NumberSequence)hashMappedList.get(n3);
            charSequence = new StringBuffer(128);
            ((StringBuffer)charSequence).append("CREATE").append(' ');
            ((StringBuffer)charSequence).append("SEQUENCE").append(' ');
            ((StringBuffer)charSequence).append(((NumberSequence)object2).getName().statementName).append(' ');
            ((StringBuffer)charSequence).append("AS").append(' ');
            ((StringBuffer)charSequence).append(Types.getTypeString(((NumberSequence)object2).getType())).append(' ');
            ((StringBuffer)charSequence).append("START").append(' ');
            ((StringBuffer)charSequence).append("WITH").append(' ');
            ((StringBuffer)charSequence).append(((NumberSequence)object2).peek()).append(' ');
            if (((NumberSequence)object2).getIncrement() != 1L) {
                ((StringBuffer)charSequence).append("INCREMENT").append(' ');
                ((StringBuffer)charSequence).append("BY").append(' ');
                ((StringBuffer)charSequence).append(((NumberSequence)object2).getIncrement()).append(' ');
            }
            DatabaseScript.addRow(result, ((StringBuffer)charSequence).toString());
        }
        n4 = hsqlArrayList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            object2 = (Table)hsqlArrayList.get(n3);
            if (((Table)object2).isTemp() || ((Table)object2).isView()) continue;
            charSequence = new StringBuffer(128);
            DatabaseScript.getTableDDL(database, (Table)object2, n3, hsqlArrayList2, hsqlArrayList3, (StringBuffer)charSequence);
            DatabaseScript.addRow(result, ((StringBuffer)charSequence).toString());
            for (int i = 1; i < ((Table)object2).getIndexCount(); ++i) {
                object = ((Table)object2).getIndex(i);
                if (HsqlNameManager.HsqlName.isReservedIndexName(((Index)object).getName().name)) continue;
                charSequence = new StringBuffer(64);
                ((StringBuffer)charSequence).append("CREATE").append(' ');
                if (((Index)object).isUnique()) {
                    ((StringBuffer)charSequence).append("UNIQUE").append(' ');
                }
                ((StringBuffer)charSequence).append("INDEX").append(' ');
                ((StringBuffer)charSequence).append(((Index)object).getName().statementName);
                ((StringBuffer)charSequence).append(' ').append("ON").append(' ');
                ((StringBuffer)charSequence).append(((Table)object2).getName().statementName);
                int[] nArray = ((Index)object).getColumns();
                n5 = ((Index)object).getVisibleColumns();
                DatabaseScript.getColumnList((Table)object2, nArray, n5, (StringBuffer)charSequence);
                DatabaseScript.addRow(result, ((StringBuffer)charSequence).toString());
            }
            if (((Table)object2).isText() && ((Table)object2).isDataReadOnly()) {
                charSequence = new StringBuffer(64);
                ((StringBuffer)charSequence).append("SET").append(' ').append("TABLE").append(' ');
                ((StringBuffer)charSequence).append(((Table)object2).getName().statementName);
                ((StringBuffer)charSequence).append(' ').append("READONLY").append(' ').append("TRUE");
                DatabaseScript.addRow(result, ((StringBuffer)charSequence).toString());
            }
            if ((string = DatabaseScript.getDataSource((Table)object2)) != null) {
                DatabaseScript.addRow(result, string);
            }
            object = DatabaseScript.getDataSourceHeader((Table)object2);
            if (!bl && object != null) {
                DatabaseScript.addRow(result, (String)object);
            }
            int n6 = 12;
            for (n5 = 0; n5 < n6; ++n5) {
                HsqlArrayList hsqlArrayList4 = ((Table)object2).triggerLists[n5];
                if (hsqlArrayList4 == null) continue;
                n2 = hsqlArrayList4.size();
                for (int i = 0; i < n2; ++i) {
                    charSequence = ((TriggerDef)hsqlArrayList4.get(i)).getDDL();
                    DatabaseScript.addRow(result, ((StringBuffer)charSequence).toString());
                }
            }
        }
        n4 = hsqlArrayList2.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (Constraint)hsqlArrayList2.get(n3);
            charSequence = new StringBuffer(128);
            ((StringBuffer)charSequence).append("ALTER").append(' ').append("TABLE").append(' ');
            ((StringBuffer)charSequence).append(((Constraint)object2).getRef().getName().statementName);
            ((StringBuffer)charSequence).append(' ').append("ADD").append(' ');
            DatabaseScript.getFKStatement((Constraint)object2, (StringBuffer)charSequence);
            DatabaseScript.addRow(result, ((StringBuffer)charSequence).toString());
        }
        n4 = hsqlArrayList.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (Table)hsqlArrayList.get(n3);
            if (!bl || !((Table)object2).isIndexCached() || ((Table)object2).isEmpty()) continue;
            DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)hsqlArrayList.get(n3)));
        }
        if (database.isIgnoreCase()) {
            DatabaseScript.addRow(result, "SET IGNORECASE TRUE");
        }
        HashMap hashMap = database.getAliasMap();
        HashMap hashMap2 = Library.getAliasMap();
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            charSequence = (String)object2.next();
            string = (String)hashMap.get(charSequence);
            object = (String)hashMap2.get(charSequence);
            if (object != null && ((String)object).equals(string)) continue;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("CREATE").append(' ').append("ALIAS").append(' ');
            stringBuffer.append((String)charSequence);
            stringBuffer.append(" FOR \"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        int n7 = hsqlArrayList.size();
        for (n = 0; n < n7; ++n) {
            object = (Table)hsqlArrayList.get(n);
            if (!((Table)object).isView()) continue;
            View view = (View)hsqlArrayList.get(n);
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("CREATE").append(' ').append("VIEW").append(' ');
            stringBuffer.append(view.getName().statementName).append(' ').append('(');
            int n8 = view.getColumnCount();
            for (n2 = 0; n2 < n8; ++n2) {
                stringBuffer.append(view.getColumn((int)n2).columnName.statementName);
                if (n2 >= n8 - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(')').append(' ').append("AS").append(' ');
            stringBuffer.append(view.getStatement());
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        DatabaseScript.addRightsStatements(database, result);
        if (database.logger.hasLog()) {
            n = database.logger.getWriteDelay();
            String string2 = "SET WRITE_DELAY " + n;
            DatabaseScript.addRow(result, string2);
        }
        return result;
    }

    static String getIndexRootsDDL(Table table) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("INDEX").append('\'');
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, StringBuffer stringBuffer) {
        Object object;
        Object object2;
        stringBuffer.append("CREATE").append(' ');
        if (table.isText()) {
            stringBuffer.append("TEXT").append(' ');
        } else if (table.isCached()) {
            stringBuffer.append("CACHED").append(' ');
        } else {
            stringBuffer.append("MEMORY").append(' ');
        }
        stringBuffer.append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        for (int i = 0; i < n2; ++i) {
            Column column = table.getColumn(i);
            String string = column.columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            object2 = Types.getTypeString(column.getType());
            stringBuffer.append((String)object2);
            if (column.getSize() > 0) {
                stringBuffer.append('(');
                stringBuffer.append(column.getSize());
                if (column.getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(column.getScale());
                }
                stringBuffer.append(')');
            }
            if ((object = column.getDefaultDDL()) != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append((String)object);
            }
            if (i == table.getIdentityColumn()) {
                stringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                stringBuffer.append(column.identityStart);
                if (column.identityIncrement != 1L) {
                    stringBuffer.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
                    stringBuffer.append(column.identityIncrement);
                }
                stringBuffer.append(") ");
            }
            if (!column.isNullable()) {
                stringBuffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length == 1 && i == nArray[0] && index.getName().isReservedIndexName()) {
                stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        if (nArray.length > 1 || !index.getName().isReservedIndexName()) {
            stringBuffer.append(',').append("CONSTRAINT").append(' ');
            stringBuffer.append(index.getName().statementName);
            stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        Constraint[] constraintArray = table.getConstraints();
        int n3 = constraintArray.length;
        block8: for (int i = 0; i < n3; ++i) {
            object2 = constraintArray[i];
            switch (((Constraint)object2).getType()) {
                case 2: {
                    stringBuffer.append(',').append("CONSTRAINT").append(' ');
                    stringBuffer.append(((Constraint)object2).getName().statementName);
                    stringBuffer.append(' ').append("UNIQUE");
                    object = ((Constraint)object2).getMainColumns();
                    DatabaseScript.getColumnList(((Constraint)object2).getMain(), (int[])object, ((Object)object).length, stringBuffer);
                    continue block8;
                }
                case 0: {
                    Table table2 = ((Constraint)object2).getMain();
                    int n4 = database.getTableIndex(table2);
                    if (n4 > n) {
                        if (n >= hsqlArrayList2.size()) {
                            hsqlArrayList2.setSize(n + 1);
                        }
                        hsqlArrayList2.set(n, object2);
                        hsqlArrayList.add(object2);
                        continue block8;
                    }
                    stringBuffer.append(',');
                    DatabaseScript.getFKStatement((Constraint)object2, stringBuffer);
                    continue block8;
                }
                case 3: {
                    try {
                        stringBuffer.append(',').append("CONSTRAINT").append(' ');
                        stringBuffer.append(((Constraint)object2).getName().statementName);
                        stringBuffer.append(' ').append("CHECK").append('(');
                        stringBuffer.append(((Constraint)object2).core.check.getDDL());
                        stringBuffer.append(')');
                        continue block8;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
        }
        stringBuffer.append(')');
    }

    static String getDataSource(Table table) {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ').append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(' ').append("DESC");
        }
        return stringBuffer.toString();
    }

    static String getDataSourceHeader(Table table) {
        String string = table.getHeader();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ');
        stringBuffer.append("HEADER").append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(table.getColumn((int)nArray[i]).columnName.statementName);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT").append(' ');
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(' ').append("FOREIGN").append(' ').append("KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(' ').append("REFERENCES").append(' ');
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.getDeleteAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getDeleteAction()));
        }
        if (constraint.getUpdateAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getUpdateAction()));
        }
    }

    private static String getFKAction(int n) {
        switch (n) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private static void addRightsStatements(Database database, Result result) {
        HashMappedList hashMappedList = database.getUserManager().getUsers();
        Iterator iterator = hashMappedList.values().iterator();
        while (iterator.hasNext()) {
            IntValueHashMap intValueHashMap;
            User user = (User)iterator.next();
            String string = user.getName();
            if (!string.equals("PUBLIC")) {
                DatabaseScript.addRow(result, user.getCreateUserDDL());
            }
            if ((intValueHashMap = user.getRights()) == null) continue;
            Iterator iterator2 = intValueHashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                int n = intValueHashMap.get(object, 0);
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("GRANT").append(' ');
                stringBuffer.append(UserManager.getRight(n));
                stringBuffer.append(' ').append("ON").append(' ');
                if (object instanceof String) {
                    if (object.equals("java.lang.Math") || object.equals("org.hsqldb.Library")) continue;
                    stringBuffer.append("CLASS \"");
                    stringBuffer.append((String)object);
                    stringBuffer.append('\"');
                } else {
                    Table table = database.findUserTable(((HsqlNameManager.HsqlName)object).name);
                    if (table == null) continue;
                    stringBuffer.append(((HsqlNameManager.HsqlName)object).statementName);
                }
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(user.getName());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
        }
    }
}

