/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.Section;
import org.jboss.verifier.strategy.AbstractEJB2xVerifier;
import org.jboss.verifier.strategy.VerificationContext;

public class EJBVerifier21
extends AbstractEJB2xVerifier {
    private static Logger log = Logger.getLogger((Class)EJBVerifier21.class);

    public EJBVerifier21(VerificationContext context) {
        super(context);
    }

    public String getMessageBundle() {
        return "EJB21Messages.properties";
    }

    public void checkSession(SessionMetaData session) {
        boolean localOrRemoteExists = false;
        boolean serviceEndpointExists = false;
        boolean verified = false;
        if (!this.verifyBean((BeanMetaData)session)) {
            return;
        }
        verified = this.verifySessionBean(session);
        if (this.hasRemoteInterfaces((BeanMetaData)session)) {
            localOrRemoteExists = true;
            verified = verified && this.verifySessionRemote(session);
            boolean bl = verified = verified && this.verifySessionHome(session);
        }
        if (this.hasLocalInterfaces((BeanMetaData)session)) {
            localOrRemoteExists = true;
            verified = verified && this.verifySessionLocal(session);
            boolean bl = verified = verified && this.verifySessionLocalHome(session);
        }
        if (this.hasServiceEndpointInterfaces(session)) {
            serviceEndpointExists = true;
            boolean bl = verified = verified && this.verifyServiceEndpoint(session);
        }
        if (!localOrRemoteExists && !serviceEndpointExists) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.1"));
            verified = false;
        }
        if (verified) {
            this.fireBeanVerifiedEvent((BeanMetaData)session);
        }
    }

    public void checkEntity(EntityMetaData entity) {
        if (entity.isCMP1x()) {
            this.cmp1XVerifier.checkEntity(entity);
        } else {
            this.checkBmpOrCmp2Entity(entity);
        }
    }

    public void checkMessageBean(MessageDrivenMetaData mdb) {
        boolean beanVerified = false;
        if (!this.verifyBean((BeanMetaData)mdb)) {
            return;
        }
        beanVerified = this.verifyMessageDrivenBean(mdb);
        if (beanVerified) {
            this.fireBeanVerifiedEvent((BeanMetaData)mdb);
        }
    }

    private void checkBmpOrCmp2Entity(EntityMetaData entity) {
        boolean localOrRemoteExists = false;
        boolean verified = false;
        if (!this.verifyBean((BeanMetaData)entity)) {
            return;
        }
        if (entity.isCMP()) {
            verified = this.verifyCMPEntityBean(entity);
        } else if (entity.isBMP()) {
            verified = this.verifyBMPEntityBean(entity);
        }
        if (this.hasRemoteInterfaces((BeanMetaData)entity)) {
            localOrRemoteExists = true;
            verified = verified && this.verifyEntityRemote(entity);
            boolean bl = verified = verified && this.verifyEntityHome(entity);
        }
        if (this.hasLocalInterfaces((BeanMetaData)entity)) {
            localOrRemoteExists = true;
            verified = verified && this.verifyEntityLocal(entity);
            verified = verified && this.verifyEntityLocalHome(entity);
        }
        boolean bl = verified = verified && this.verifyPrimaryKey(entity);
        if (!localOrRemoteExists) {
            if (entity.isCMP()) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.1"));
                verified = false;
            } else {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.1"));
                verified = false;
            }
        }
        if (verified) {
            this.fireBeanVerifiedEvent((BeanMetaData)entity);
        }
    }

    protected boolean verifyBean(BeanMetaData theBean) {
        String beanName = theBean.getEjbClass();
        if (beanName == null) {
            return false;
        }
        try {
            this.bean = this.classloader.loadClass(beanName);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(theBean, new Section("22.2.b", "Class not found on '" + beanName + "': " + cnfe.getMessage()));
            return false;
        }
    }

    protected boolean hasRemoteInterfaces(BeanMetaData bean) {
        boolean status = true;
        String homeName = bean.getHome();
        String remoteName = bean.getRemote();
        if (homeName == null || remoteName == null) {
            return false;
        }
        try {
            this.home = this.classloader.loadClass(homeName);
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(bean, new Section("22.2.c", "Class not found on '" + homeName + "': " + cnfe.getMessage()));
            status = false;
        }
        try {
            this.remote = this.classloader.loadClass(remoteName);
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(bean, new Section("22.2.d", "Class not found on '" + remoteName + "': " + cnfe.getMessage()));
            status = false;
        }
        return status;
    }

    protected boolean hasLocalInterfaces(BeanMetaData bean) {
        boolean status = true;
        String localHomeName = bean.getLocalHome();
        String localName = bean.getLocal();
        if (localHomeName == null || localName == null) {
            return false;
        }
        try {
            this.localHome = this.classloader.loadClass(localHomeName);
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(bean, new Section("22.2.e", "Class not found on '" + localHomeName + "': " + cnfe.getMessage()));
            status = false;
        }
        try {
            this.local = this.classloader.loadClass(localName);
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent(bean, new Section("22.2.f", "Class not found on '" + localName + "': " + cnfe.getMessage()));
            status = false;
        }
        return status;
    }

    protected boolean verifySessionHome(SessionMetaData session) {
        boolean status = true;
        if (session.isStateless()) {
            if (!this.hasDefaultCreateMethod(this.home)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.6.d2"));
                status = false;
            } else {
                Method create = this.getDefaultCreateMethod(this.home);
                if (this.hasMoreThanOneCreateMethods(this.home)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.6.d2"));
                    status = false;
                }
            }
        }
        if (!this.hasEJBHomeInterface(this.home)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.6.a"));
            status = false;
        }
        Iterator<Method> it = Arrays.asList(this.home.getMethods()).iterator();
        while (it.hasNext()) {
            Method method = it.next();
            if (!this.hasLegalRMIIIOPArguments(method)) {
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.6.b1"));
                status = false;
            }
            if (!this.hasLegalRMIIIOPReturnType(method)) {
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.6.b2"));
                status = false;
            }
            if (this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.6.b3"));
            status = false;
        }
        if (!this.hasCreateMethod(this.home)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.6.d1"));
            status = false;
        }
        Iterator createMethods = this.getCreateMethods(this.home);
        while (createMethods.hasNext()) {
            Method ejbCreate;
            Method create = (Method)createMethods.next();
            if (!this.hasMatchingEJBCreate(this.bean, create)) {
                this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.6.e"));
                status = false;
            }
            if (!this.hasRemoteReturnType((BeanMetaData)session, create)) {
                this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.6.f"));
                status = false;
            }
            if (this.hasMatchingEJBCreate(this.bean, create) && !this.hasMatchingExceptions(ejbCreate = this.getMatchingEJBCreate(this.bean, create), create)) {
                this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.6.g"));
                status = false;
            }
            if (this.throwsCreateException(create)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.6.h"));
            status = false;
        }
        return status;
    }

    protected boolean verifySessionLocalHome(SessionMetaData session) {
        boolean status = true;
        if (session.isStateless()) {
            if (!this.hasDefaultCreateMethod(this.localHome)) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.8.d2"));
                status = false;
            } else {
                Method create = this.getDefaultCreateMethod(this.localHome);
                if (this.hasMoreThanOneCreateMethods(this.localHome)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.8.d2"));
                    status = false;
                }
            }
        }
        if (!this.hasEJBLocalHomeInterface(this.localHome)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.8.a"));
            status = false;
        }
        Iterator<Method> it = Arrays.asList(this.localHome.getMethods()).iterator();
        while (it.hasNext()) {
            Method method = it.next();
            if (!this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.8.b"));
            status = false;
        }
        if (!this.hasCreateMethod(this.localHome)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.8.d1"));
            status = false;
        }
        Iterator createMethods = this.getCreateMethods(this.localHome);
        while (createMethods.hasNext()) {
            Method ejbCreate;
            Method create = (Method)createMethods.next();
            if (!this.hasMatchingEJBCreate(this.bean, create)) {
                this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.8.e"));
                status = false;
            }
            if (!this.hasLocalReturnType((BeanMetaData)session, create)) {
                this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.8.f"));
                status = false;
            }
            if (this.hasMatchingEJBCreate(this.bean, create) && !this.hasMatchingExceptions(ejbCreate = this.getMatchingEJBCreate(this.bean, create), create)) {
                this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.8.g"));
            }
            if (this.throwsCreateException(create)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, create, new Section("7.11.8.h"));
            status = false;
        }
        return status;
    }

    protected boolean verifySessionRemote(SessionMetaData session) {
        boolean status = true;
        if (!this.hasEJBObjectInterface(this.remote)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.5.a"));
            status = false;
        }
        Iterator<Method> it = Arrays.asList(this.remote.getMethods()).iterator();
        while (it.hasNext()) {
            Method method = it.next();
            if (!this.hasLegalRMIIIOPArguments(method)) {
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.5.b1"));
                status = false;
            }
            if (!this.hasLegalRMIIIOPReturnType(method)) {
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.5.b2"));
                status = false;
            }
            if (this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.5.b3"));
            status = false;
        }
        it = Arrays.asList(this.remote.getDeclaredMethods()).iterator();
        while (it.hasNext()) {
            Method remoteMethod = it.next();
            if (!this.hasMatchingMethod(this.bean, remoteMethod)) {
                this.fireSpecViolationEvent((BeanMetaData)session, remoteMethod, new Section("7.11.5.d1"));
                status = false;
            }
            if (!this.hasMatchingMethod(this.bean, remoteMethod)) continue;
            try {
                Method beanMethod = this.bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
                if (!this.hasMatchingReturnType(remoteMethod, beanMethod)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, remoteMethod, new Section("7.11.5.d2"));
                    status = false;
                }
                if (this.hasMatchingExceptions(beanMethod, remoteMethod)) continue;
                this.fireSpecViolationEvent((BeanMetaData)session, remoteMethod, new Section("7.11.5.d3"));
                status = false;
            }
            catch (NoSuchMethodException ignored) {}
        }
        return status;
    }

    protected boolean verifySessionLocal(SessionMetaData session) {
        boolean status = true;
        if (!this.hasEJBLocalObjectInterface(this.local)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.7.a"));
            status = false;
        }
        Iterator<Method> it = Arrays.asList(this.local.getMethods()).iterator();
        while (it.hasNext()) {
            Method method = it.next();
            if (!this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.7.b"));
            status = false;
        }
        it = Arrays.asList(this.local.getDeclaredMethods()).iterator();
        while (it.hasNext()) {
            Method localMethod = it.next();
            if (!this.hasMatchingMethod(this.bean, localMethod)) {
                this.fireSpecViolationEvent((BeanMetaData)session, localMethod, new Section("7.11.7.d1"));
                status = false;
            }
            if (!this.hasMatchingMethod(this.bean, localMethod)) continue;
            try {
                Method beanMethod = this.bean.getMethod(localMethod.getName(), localMethod.getParameterTypes());
                if (!this.hasMatchingReturnType(localMethod, beanMethod)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, localMethod, new Section("7.11.7.d2"));
                    status = false;
                }
                if (this.hasMatchingExceptions(beanMethod, localMethod)) continue;
                this.fireSpecViolationEvent((BeanMetaData)session, localMethod, new Section("7.11.7.d3"));
                status = false;
            }
            catch (NoSuchMethodException ignored) {}
        }
        return status;
    }

    protected boolean verifySessionBean(SessionMetaData session) {
        boolean status = true;
        if (!this.hasSessionBeanInterface(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.2.a"));
            status = false;
        }
        if (this.hasSessionSynchronizationInterface(this.bean)) {
            if (session.isStateless()) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.5.3.a"));
                status = false;
            }
            if (session.isBeanManagedTx()) {
                this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.5.3.b"));
                status = false;
            }
        }
        if (!this.hasEJBCreateMethod(this.bean, true)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.3"));
            status = false;
        }
        if (this.hasSessionSynchronizationInterface(this.bean) && session.isBeanManagedTx()) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.6.1"));
            status = false;
        }
        if (!this.isPublic(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.2.b1"));
            status = false;
        }
        if (this.isFinal(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.2.b2"));
            status = false;
        }
        if (this.isAbstract(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.2.b3"));
            status = false;
        }
        if (!this.hasDefaultConstructor(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.2.c"));
            status = false;
        }
        if (this.hasFinalizer(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.2.d"));
            status = false;
        }
        if (this.hasEJBCreateMethod(this.bean, true)) {
            Iterator it = this.getEJBCreateMethods(this.bean);
            while (it.hasNext()) {
                Method ejbCreate = (Method)it.next();
                if (!this.isPublic(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("7.11.3.b"));
                    status = false;
                }
                if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("7.11.3.c"));
                    status = false;
                }
                if (!this.hasVoidReturnType(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("7.11.3.d"));
                    status = false;
                }
                if (this.hasLegalRMIIIOPArguments(ejbCreate)) continue;
                this.fireSpecViolationEvent((BeanMetaData)session, ejbCreate, new Section("7.11.3.e"));
                status = false;
            }
        }
        return status;
    }

    private boolean verifyEntityHome(EntityMetaData entity) {
        Method method;
        boolean status = true;
        if (!this.hasEJBHomeInterface(this.home)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.9.a"));
            status = false;
        }
        Iterator<Method> methods = Arrays.asList(this.home.getMethods()).iterator();
        while (methods.hasNext()) {
            method = methods.next();
            if (!this.hasLegalRMIIIOPArguments(method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.b1"));
                status = false;
            }
            if (!this.hasLegalRMIIIOPReturnType(method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.b2"));
                status = false;
            }
            if (this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.b3"));
            status = false;
        }
        methods = Arrays.asList(this.home.getMethods()).iterator();
        while (methods.hasNext()) {
            method = methods.next();
            if (method.getDeclaringClass().getName().equals("javax.ejb.EJBHome")) continue;
            if (this.isCreateMethod(method)) {
                if (!this.hasMatchingEJBCreate(this.bean, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.d"));
                    status = false;
                }
                if (!this.hasRemoteReturnType((BeanMetaData)entity, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.e"));
                    status = false;
                }
                if (this.hasMatchingEJBCreate(this.bean, method) && this.hasMatchingEJBPostCreate(this.bean, method)) {
                    Method ejbCreate = this.getMatchingEJBCreate(this.bean, method);
                    Method ejbPostCreate = this.getMatchingEJBPostCreate(this.bean, method);
                    if (!this.hasMatchingExceptions(ejbCreate, method) || !this.hasMatchingExceptions(ejbPostCreate, method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.f"));
                    }
                }
                if (this.throwsCreateException(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.g"));
                status = false;
                continue;
            }
            if (this.isFinderMethod(method)) {
                if (entity.isBMP()) {
                    Method ejbFind;
                    if (!this.hasMatchingEJBFind(this.bean, method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.h"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType((BeanMetaData)entity, method) && !this.isMultiObjectFinder(method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.j"));
                        status = false;
                    }
                    if (this.hasMatchingEJBFind(this.bean, method) && !this.hasMatchingExceptions(ejbFind = this.getMatchingEJBFind(this.bean, method), method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.k"));
                        status = false;
                    }
                    if (!this.throwsFinderException(method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.l"));
                        status = false;
                    }
                }
                if (!entity.isCMP()) continue;
                if (!this.hasRemoteReturnType((BeanMetaData)entity, method) && !this.isMultiObjectFinder(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("10.6.10.a"));
                    status = false;
                }
                if (!this.throwsFinderException(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("10.6.10.b"));
                    status = false;
                }
                if (method.getName().equals("findByPrimaryKey") || method.getName().equals("findAll") || this.hasMatchingQuery(method, entity)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("10.5.6"));
                status = false;
                continue;
            }
            if (this.hasMatchingEJBHome(this.bean, method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.9.m"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityLocalHome(EntityMetaData entity) {
        Method method;
        boolean status = true;
        if (!this.hasEJBLocalHomeInterface(this.localHome)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.11.a"));
            status = false;
        }
        Iterator<Method> homeMethods = Arrays.asList(this.localHome.getMethods()).iterator();
        while (homeMethods.hasNext()) {
            method = homeMethods.next();
            if (!this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.b"));
            status = false;
        }
        homeMethods = Arrays.asList(this.localHome.getMethods()).iterator();
        while (homeMethods.hasNext()) {
            method = homeMethods.next();
            if (method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome")) continue;
            if (this.isCreateMethod(method)) {
                if (!this.hasMatchingEJBCreate(this.bean, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.e"));
                    status = false;
                }
                if (!this.hasLocalReturnType((BeanMetaData)entity, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.f"));
                    status = false;
                }
                if (this.hasMatchingEJBCreate(this.bean, method) && this.hasMatchingEJBPostCreate(this.bean, method)) {
                    Method ejbCreate = this.getMatchingEJBCreate(this.bean, method);
                    Method ejbPostCreate = this.getMatchingEJBPostCreate(this.bean, method);
                    if (!this.hasMatchingExceptions(ejbCreate, method) || !this.hasMatchingExceptions(ejbPostCreate, method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.g"));
                    }
                }
                if (this.throwsCreateException(method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.h"));
                status = false;
                continue;
            }
            if (this.isFinderMethod(method)) {
                if (!this.hasLocalReturnType((BeanMetaData)entity, method) && !this.isMultiObjectFinder(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.j"));
                    status = false;
                }
                if (!this.throwsFinderException(method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.k"));
                    status = false;
                }
                if (entity.isCMP()) {
                    if (this.hasMatchingEJBFind(this.bean, method)) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("10.6.2.j"));
                        status = false;
                    }
                    if (!(method.getName().equals("findByPrimaryKey") || method.getName().equals("findAll") || this.hasMatchingQuery(method, entity))) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("10.5.6"));
                        status = false;
                    }
                }
                if (!entity.isBMP()) continue;
                if (!this.hasMatchingEJBFind(this.bean, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.i"));
                    status = false;
                    continue;
                }
                Method ejbFind = this.getMatchingEJBFind(this.bean, method);
                if (this.hasMatchingExceptions(ejbFind, method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.l"));
                continue;
            }
            if (this.hasMatchingEJBHome(this.bean, method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.11.m"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityLocal(EntityMetaData entity) {
        Method method;
        boolean status = true;
        if (!this.hasEJBLocalObjectInterface(this.local)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.10.a"));
            status = false;
        }
        Iterator<Method> localMethods = Arrays.asList(this.local.getMethods()).iterator();
        while (localMethods.hasNext()) {
            method = localMethods.next();
            if (!this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.10.b"));
            status = false;
        }
        localMethods = Arrays.asList(this.local.getMethods()).iterator();
        while (localMethods.hasNext()) {
            method = localMethods.next();
            if (method.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) continue;
            if (!this.hasMatchingMethod(this.bean, method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.10.c"));
                status = false;
            }
            if (!this.hasMatchingMethod(this.bean, method)) continue;
            try {
                Method beanMethod = this.bean.getMethod(method.getName(), method.getParameterTypes());
                if (!this.hasMatchingReturnType(beanMethod, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.10.d"));
                    status = false;
                }
                if (this.hasMatchingExceptions(beanMethod, method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("12.2.10.e"));
                status = false;
            }
            catch (NoSuchMethodException ignored) {}
        }
        return status;
    }

    private boolean verifyEntityRemote(EntityMetaData entity) {
        Method method;
        boolean status = true;
        if (!this.hasEJBObjectInterface(this.remote)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("9.2.7.a"));
            status = false;
        }
        Iterator<Method> it = Arrays.asList(this.remote.getMethods()).iterator();
        while (it.hasNext()) {
            method = it.next();
            if (!this.hasLegalRMIIIOPArguments(method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.b"));
                status = false;
            }
            if (!this.hasLegalRMIIIOPReturnType(method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.c"));
                status = false;
            }
            if (!this.hasLegalRMIIIOPExceptionTypes(method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.h"));
                status = false;
            }
            if (this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.d"));
            status = false;
        }
        it = Arrays.asList(this.remote.getMethods()).iterator();
        while (it.hasNext()) {
            method = it.next();
            if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
            if (!this.hasMatchingMethod(this.bean, method)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.e"));
                status = false;
            }
            if (!this.hasMatchingMethod(this.bean, method)) continue;
            try {
                Method beanMethod = this.bean.getMethod(method.getName(), method.getParameterTypes());
                if (!this.hasMatchingReturnType(beanMethod, method)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.f"));
                    status = false;
                }
                if (this.hasMatchingExceptions(beanMethod, method)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, method, new Section("9.2.7.g"));
                status = false;
            }
            catch (NoSuchMethodException ignored) {}
        }
        return status;
    }

    private boolean verifyCMPEntityBean(EntityMetaData entity) {
        Method ejbCreate;
        Iterator it;
        boolean status = true;
        if (!this.hasEntityBeanInterface(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.a"));
            status = false;
        }
        if (!this.isPublic(this.bean) || !this.isAbstract(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.b"));
            status = false;
        }
        if (!this.hasDefaultConstructor(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.c"));
            status = false;
        }
        if (this.hasFinalizer(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.d"));
            status = false;
        }
        if (this.hasEJBCreateMethod(this.bean, false)) {
            it = this.getEJBCreateMethods(this.bean);
            while (it.hasNext()) {
                ejbCreate = (Method)it.next();
                if (!this.isPublic(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("10.6.4.b"));
                    status = false;
                }
                if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("10.6.4.c"));
                    status = false;
                }
                if (!this.hasPrimaryKeyReturnType(entity, ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("10.6.4.d"));
                    status = false;
                }
                if (this.throwsCreateException(ejbCreate)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("10.6.4.g"));
                status = false;
            }
        }
        if (this.hasEJBCreateMethod(this.bean, false)) {
            it = this.getEJBCreateMethods(this.bean);
            while (it.hasNext()) {
                ejbCreate = (Method)it.next();
                if (!this.hasMatchingEJBPostCreate(this.bean, ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("10.6.5.a"));
                    status = false;
                }
                if (!this.hasMatchingEJBPostCreate(this.bean, ejbCreate)) continue;
                Method ejbPostCreate = this.getMatchingEJBPostCreate(this.bean, ejbCreate);
                if (!this.isPublic(ejbPostCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("10.6.5.b"));
                    status = false;
                }
                if (this.isStatic(ejbPostCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("10.6.5.c"));
                    status = false;
                }
                if (this.isFinal(ejbPostCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("10.6.5.d"));
                    status = false;
                }
                if (this.hasVoidReturnType(ejbPostCreate)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("10.6.5.e"));
                status = false;
            }
        }
        it = this.getEjbHomeMethods(this.bean);
        while (it.hasNext()) {
            Method ejbHome = (Method)it.next();
            if (!this.isPublic(ejbHome)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbHome, new Section("10.6.6.a"));
                status = false;
            }
            if (this.isStatic(ejbHome)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbHome, new Section("10.6.6.b"));
                status = false;
            }
            if (!this.throwsRemoteException(ejbHome)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, ejbHome, new Section("10.6.6.c"));
            status = false;
        }
        it = entity.getCMPFields();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            String getName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Class<?> fieldType = null;
            try {
                Method m = this.bean.getMethod(getName, new Class[0]);
                fieldType = m.getReturnType();
                if (fieldType == Void.TYPE) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, new Section("jb.7.1.b", "Field: " + fieldName));
                }
            }
            catch (NoSuchMethodException nsme) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.g", "Field: " + fieldName));
                status = false;
            }
            String setName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Class[] args = new Class[]{fieldType};
            try {
                Method m = this.bean.getMethod(setName, args);
                fieldType = m.getReturnType();
                if (fieldType == Void.TYPE) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("jb.7.1.a", "Field: " + fieldName));
            }
            catch (NoSuchMethodException nsme) {
                try {
                    args[0] = this.classloader.loadClass("java.util.Collection");
                    Method m = this.bean.getMethod(setName, args);
                }
                catch (NoSuchMethodException nsme2) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.h", "Field: " + fieldName));
                    status = false;
                }
                catch (ClassNotFoundException cnfe) {}
            }
        }
        it = this.getEjbSelectMethods(this.bean);
        while (it.hasNext()) {
            Method ejbSelect = (Method)it.next();
            if (!this.isPublic(ejbSelect)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbSelect, new Section("10.6.7.a"));
                status = false;
            }
            if (!this.isAbstract(ejbSelect)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbSelect, new Section("10.6.7.b"));
                status = false;
            }
            if (!this.throwsFinderException(ejbSelect)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbSelect, new Section("10.6.7.c"));
                status = false;
            }
            if (this.hasMatchingQuery(ejbSelect, entity)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, ejbSelect, new Section("10.5.7"));
            status = false;
        }
        if (this.hasFinderMethod(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.2.i"));
            status = false;
        }
        return status;
    }

    private boolean verifyBMPEntityBean(EntityMetaData entity) {
        Method ejbCreate;
        Iterator it;
        boolean status = true;
        if (!this.hasEntityBeanInterface(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.2.a"));
            status = false;
        }
        if (!this.isPublic(this.bean) || this.isAbstract(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.2.b"));
            status = false;
        }
        if (this.isFinal(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.2.c"));
            status = false;
        }
        if (!this.hasDefaultConstructor(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.2.d"));
            status = false;
        }
        if (this.hasFinalizer(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.2.e"));
            status = false;
        }
        if (this.hasEJBCreateMethod(this.bean, false)) {
            it = this.getEJBCreateMethods(this.bean);
            while (it.hasNext()) {
                ejbCreate = (Method)it.next();
                if (!this.isPublic(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("12.2.3.a"));
                    status = false;
                }
                if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("12.2.3.b"));
                    status = false;
                }
                if (this.hasPrimaryKeyReturnType(entity, ejbCreate)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("12.2.3.c"));
                status = false;
            }
        }
        if (this.hasEJBCreateMethod(this.bean, false)) {
            it = this.getEJBCreateMethods(this.bean);
            while (it.hasNext()) {
                ejbCreate = (Method)it.next();
                if (!this.hasMatchingEJBPostCreate(this.bean, ejbCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbCreate, new Section("12.2.4.a"));
                    status = false;
                }
                if (!this.hasMatchingEJBPostCreate(this.bean, ejbCreate)) continue;
                Method ejbPostCreate = this.getMatchingEJBPostCreate(this.bean, ejbCreate);
                if (!this.isPublic(ejbPostCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("12.2.4.b"));
                    status = false;
                }
                if (this.isStatic(ejbPostCreate) || this.isFinal(ejbPostCreate)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("12.2.4.c"));
                    status = false;
                }
                if (this.hasVoidReturnType(ejbPostCreate)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbPostCreate, new Section("12.2.4.d"));
                status = false;
            }
        }
        if (!this.hasEJBFindByPrimaryKey(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.5.e"));
            status = false;
        }
        if (this.hasEJBFindByPrimaryKey(this.bean)) {
            Method ejbFindByPrimaryKey = this.getEJBFindByPrimaryKey(this.bean);
            if (!this.hasPrimaryKeyReturnType(entity, ejbFindByPrimaryKey)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbFindByPrimaryKey, new Section("12.2.5.e1"));
                status = false;
            }
            if (!this.isSingleObjectFinder(entity, ejbFindByPrimaryKey)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbFindByPrimaryKey, new Section("12.2.5.e2"));
                status = false;
            }
        }
        if (this.hasFinderMethod(this.bean)) {
            it = this.getEJBFindMethods(this.bean);
            while (it.hasNext()) {
                Method finder = (Method)it.next();
                if (!this.isPublic(finder)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("12.2.5.a"));
                    status = false;
                }
                if (this.isFinal(finder) || this.isStatic(finder)) {
                    this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("12.2.5.b"));
                    status = false;
                }
                if (this.isSingleObjectFinder(entity, finder) || this.isMultiObjectFinder(finder)) continue;
                this.fireSpecViolationEvent((BeanMetaData)entity, finder, new Section("12.2.5.d"));
                status = false;
            }
        }
        it = this.getEjbHomeMethods(this.bean);
        while (it.hasNext()) {
            Method ejbHome = (Method)it.next();
            if (!this.isPublic(ejbHome)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbHome, new Section("10.6.6.a"));
                status = false;
            }
            if (this.isStatic(ejbHome)) {
                this.fireSpecViolationEvent((BeanMetaData)entity, ejbHome, new Section("10.6.6.b"));
                status = false;
            }
            if (!this.throwsRemoteException(ejbHome)) continue;
            this.fireSpecViolationEvent((BeanMetaData)entity, ejbHome, new Section("10.6.6.c"));
            status = false;
        }
        return status;
    }

    private boolean verifyPrimaryKey(EntityMetaData entity) {
        boolean status = true;
        boolean cmp = entity.isCMP();
        if (entity.getPrimaryKeyClass() == null || entity.getPrimaryKeyClass().length() == 0) {
            if (cmp) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.1.a"));
            } else {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.1.a"));
            }
            return false;
        }
        Class<?> cls = null;
        try {
            cls = this.classloader.loadClass(entity.getPrimaryKeyClass());
        }
        catch (ClassNotFoundException e) {
            if (cmp) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.13.a"));
            } else {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.12.a"));
            }
            return false;
        }
        if (!this.isRMIIDLValueType(cls)) {
            if (cmp) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.6.13.b"));
            } else {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("12.2.12.b"));
            }
            status = false;
        }
        if (entity.getPrimKeyField() == null || entity.getPrimKeyField().length() == 0) {
            if (!cls.getName().equals("java.lang.Object")) {
                try {
                    Object one = cls.newInstance();
                    Object two = cls.newInstance();
                    try {
                        if (!one.equals(two)) {
                            if (cmp) {
                                log.warn((Object)("Default instances of primary key: " + cls + " do not equate, check your equals method"));
                            } else {
                                log.warn((Object)("Default instances of primary key: " + cls + " do not equate, check your equals method"));
                            }
                            status = true;
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        if (one.hashCode() != two.hashCode()) {
                            if (cmp) {
                                log.warn((Object)("Default instances of primary key: " + cls + " do not have the same hash, check your hashCode method"));
                            } else {
                                log.warn((Object)("Default instances of primary key: " + cls + " do not have the same hash, check your hashCode method"));
                            }
                            status = true;
                        }
                    }
                    catch (NullPointerException e) {
                    }
                }
                catch (IllegalAccessException e) {
                    if (cmp) {
                        this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.8.2.a"));
                        status = false;
                    }
                }
                catch (InstantiationException e) {}
            }
        } else {
            if (entity.isBMP()) {
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("dd.a"));
                status = false;
            }
            boolean found = false;
            Iterator it = entity.getCMPFields();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                if (!fieldName.equals(entity.getPrimKeyField())) continue;
                found = true;
                break;
            }
            if (!found) {
                status = false;
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.8.1.b"));
            }
            try {
                String pkField = entity.getPrimKeyField();
                String methodName = "get" + pkField.substring(0, 1).toUpperCase() + pkField.substring(1);
                Method method = this.bean.getMethod(methodName, new Class[0]);
                if (!entity.getPrimaryKeyClass().equals(method.getReturnType().getName())) {
                    status = false;
                    this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.8.1.a"));
                }
            }
            catch (NoSuchMethodException e) {
                status = false;
                this.fireSpecViolationEvent((BeanMetaData)entity, new Section("10.8.1.b"));
            }
        }
        return status;
    }

    protected boolean verifyMessageDrivenBean(MessageDrivenMetaData mdBean) {
        boolean status = true;
        if (!this.hasMessageDrivenBeanInterface(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.a"));
            status = false;
        }
        if (!this.isAssignableFrom(mdBean.getMessagingType(), this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.b"));
            status = false;
        }
        if (!this.isPublic(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.c1"));
            status = false;
        }
        if (this.isFinal(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.c2"));
            status = false;
        }
        if (this.isAbstract(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.c3"));
            status = false;
        }
        if (!this.hasDefaultConstructor(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.d"));
            status = false;
        }
        if (this.hasFinalizer(this.bean)) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.e"));
            status = false;
        }
        if (this.hasEJBCreateMethod(this.bean, false)) {
            Iterator it = this.getEJBCreateMethods(this.bean);
            Method ejbCreate = (Method)it.next();
            if (!this.isPublic(ejbCreate)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbCreate, new Section("15.7.3.b"));
                status = false;
            }
            if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbCreate, new Section("15.7.3.c"));
                status = false;
            }
            if (!this.hasVoidReturnType(ejbCreate)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbCreate, new Section("15.7.3.d"));
                status = false;
            }
            if (!this.hasNoArguments(ejbCreate)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbCreate, new Section("15.7.3.e"));
                status = false;
            }
            if (!this.throwsNoException(ejbCreate)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbCreate, new Section("15.7.3.f"));
                status = false;
            }
            if (it.hasNext()) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.3.a"));
                status = false;
            }
        } else {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.3.a"));
            status = false;
        }
        Class<?> messageListener = null;
        try {
            messageListener = this.classloader.loadClass(mdBean.getMessagingType());
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.2.b", "Class not found on '" + mdBean.getMessagingType() + "': " + cnfe.getMessage()));
            status = false;
        }
        if (messageListener != null) {
            Method[] methods = this.bean.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getDeclaringClass().equals(messageListener)) continue;
                if (!this.isPublic(methods[i])) {
                    this.fireSpecViolationEvent((BeanMetaData)mdBean, methods[i], new Section("15.7.4.b"));
                    status = false;
                }
                if (!this.isFinal(methods[i]) && !this.isStatic(methods[i])) continue;
                this.fireSpecViolationEvent((BeanMetaData)mdBean, methods[i], new Section("15.7.4.c"));
                status = false;
            }
        }
        if (this.hasEJBRemoveMethod(this.bean)) {
            Iterator it = this.getEJBRemoveMethods(this.bean);
            Method ejbRemove = (Method)it.next();
            if (!this.isPublic(ejbRemove)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbRemove, new Section("15.7.5.b"));
                status = false;
            }
            if (this.isFinal(ejbRemove) || this.isStatic(ejbRemove)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbRemove, new Section("15.7.5.c"));
                status = false;
            }
            if (!this.hasVoidReturnType(ejbRemove)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbRemove, new Section("15.7.5.d"));
                status = false;
            }
            if (!this.hasNoArguments(ejbRemove)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbRemove, new Section("15.7.5.e"));
                status = false;
            }
            if (!this.throwsNoException(ejbRemove)) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, ejbRemove, new Section("15.7.5.f"));
                status = false;
            }
            if (it.hasNext()) {
                this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.5.a"));
                status = false;
            }
        } else {
            this.fireSpecViolationEvent((BeanMetaData)mdBean, new Section("15.7.5.a"));
            status = false;
        }
        return status;
    }

    protected boolean verifyServiceEndpoint(SessionMetaData session) {
        boolean status = true;
        if (!this.hasRemoteInterface(this.serviceEndpointInterface)) {
            this.fireSpecViolationEvent((BeanMetaData)session, new Section("7.11.9.a"));
            status = false;
        }
        Iterator<Method> it = Arrays.asList(this.serviceEndpointInterface.getMethods()).iterator();
        while (it.hasNext()) {
            Method method = it.next();
            if (!this.hasLegalJAXRPCArguments(method)) {
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.9.b1"));
                status = false;
            }
            if (!this.hasLegalJAXRPCReturnType(method)) {
                this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.9.b2"));
                status = false;
            }
            if (this.throwsRemoteException(method)) continue;
            this.fireSpecViolationEvent((BeanMetaData)session, method, new Section("7.11.9.b3"));
            status = false;
        }
        it = Arrays.asList(this.serviceEndpointInterface.getDeclaredMethods()).iterator();
        while (it.hasNext()) {
            Method seiMethod = it.next();
            if (!this.hasMatchingMethod(this.bean, seiMethod)) {
                this.fireSpecViolationEvent((BeanMetaData)session, seiMethod, new Section("7.11.9.c"));
                status = false;
                continue;
            }
            try {
                Method beanMethod = this.bean.getMethod(seiMethod.getName(), seiMethod.getParameterTypes());
                if (!this.hasMatchingReturnType(seiMethod, beanMethod)) {
                    this.fireSpecViolationEvent((BeanMetaData)session, seiMethod, new Section("7.11.9.c1"));
                    status = false;
                }
                if (this.hasMatchingExceptions(beanMethod, seiMethod)) continue;
                this.fireSpecViolationEvent((BeanMetaData)session, seiMethod, new Section("7.11.59.c2"));
                status = false;
            }
            catch (NoSuchMethodException ignored) {}
        }
        return status;
    }

    protected boolean hasLegalJAXRPCReturnType(Method method) {
        return this.isJAXRPCType(method.getReturnType());
    }

    protected boolean isJAXRPCType(Class class1) {
        return this.isRMIIDLValueType(class1);
    }

    protected boolean hasLegalJAXRPCArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (this.isJAXRPCType(params[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean hasServiceEndpointInterfaces(SessionMetaData bean) {
        boolean status = true;
        String seiName = bean.getServiceEndpoint();
        if (seiName == null) {
            return false;
        }
        try {
            this.serviceEndpointInterface = this.classloader.loadClass(seiName);
        }
        catch (ClassNotFoundException cnfe) {
            this.fireSpecViolationEvent((BeanMetaData)bean, new Section("23.2", "Class not found on '" + seiName + "': " + cnfe.getMessage()));
            status = false;
        }
        return status;
    }
}

